# 🔧 Hướng dẫn khắc phục CORS

## 📋 **Vấn đề hiện tại:**
- Server `https://kthcdemo.muvietplus.net` đã hoạt động ✅
- CORS error khi truy cập từ `https://api.muvietplus.net` ❌

## 🎯 **Nguyên nhân có thể:**

### **1. Preflight OPTIONS Request**
Browser tự động gửi OPTIONS request trước khi gửi POST request với JSON content-type.

### **2. CORS Headers thiếu**
Server không trả về đúng CORS headers cho preflight request.

### **3. Origin không được cho phép**
Origin `https://api.muvietplus.net` không có trong danh sách allowed origins.

## 🔧 **Giải pháp:**

### **Bước 1: Kiểm tra CORS config**

Server đã được cấu hình CORS cho:
```javascript
const allowedOrigins = [
  'https://api.muvietplus.net',        // ✅ Có
  'https://kthcdemo.muvietplus.net',   // ✅ Có
  'https://muvietplus.net',            // ✅ Có
  'https://www.muvietplus.net'         // ✅ Có
];
```

### **Bước 2: Test chi tiết**

Sử dụng file `debug-cors.html` để test:
1. **GET request** - Thường không có vấn đề
2. **POST request** - Có thể bị CORS
3. **OPTIONS request** - Preflight request

### **Bước 3: Kiểm tra server logs**

Khi có request, server sẽ log:
```
🔍 CORS Test Request (GET):
  Origin: https://api.muvietplus.net
  Referer: https://api.muvietplus.net/kthcdemo/
  User-Agent: Mozilla/5.0...

🔍 CORS Test Request (POST):
  Origin: https://api.muvietplus.net
  Body: { test: true, timestamp: 1234567890 }
```

### **Bước 4: Kiểm tra CORS headers**

Response headers phải có:
```
Access-Control-Allow-Origin: https://api.muvietplus.net
Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS
Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, Accept
Access-Control-Allow-Credentials: true
```

## 🧪 **Cách test:**

### **1. Test từ browser:**
```bash
# Mở file debug
https://api.muvietplus.net/kthcdemo/debug-cors.html
```

### **2. Test từ terminal:**
```bash
# Test GET
curl -H "Origin: https://api.muvietplus.net" \
     -H "Content-Type: application/json" \
     https://kthcdemo.muvietplus.net/api/test

# Test POST
curl -X POST \
     -H "Origin: https://api.muvietplus.net" \
     -H "Content-Type: application/json" \
     -d '{"test": true}' \
     https://kthcdemo.muvietplus.net/api/test

# Test OPTIONS (preflight)
curl -X OPTIONS \
     -H "Origin: https://api.muvietplus.net" \
     -H "Access-Control-Request-Method: POST" \
     -H "Access-Control-Request-Headers: Content-Type" \
     https://kthcdemo.muvietplus.net/api/test
```

### **3. Test ChatBot Widget:**
```javascript
// Trong browser console
fetch('https://kthcdemo.muvietplus.net/api/chat', {
  method: 'POST',
  headers: {
    'Content-Type': 'application/json'
  },
  body: JSON.stringify({
    sessionId: 'test',
    message: 'test'
  })
}).then(r => r.json()).then(console.log);
```

## 🚨 **Nếu vẫn lỗi:**

### **1. Kiểm tra server status:**
```bash
# Kiểm tra server có chạy không
curl https://kthcdemo.muvietplus.net/api/health
```

### **2. Kiểm tra firewall/proxy:**
- Có thể firewall chặn OPTIONS request
- Proxy server có thể không forward CORS headers

### **3. Kiểm tra hosting config:**
- Nginx/Apache có thể cần cấu hình CORS
- Cloudflare có thể chặn preflight requests

### **4. Fallback solution:**
Sử dụng cùng domain cho frontend và backend:
```javascript
// Trong chatbot-widget.js
BASE_URL: 'https://api.muvietplus.net'  // Thay vì kthcdemo.muvietplus.net
```

## 📞 **Debug steps:**

1. **Mở browser DevTools** → Network tab
2. **Gửi request** từ ChatBot
3. **Kiểm tra OPTIONS request** (preflight)
4. **Kiểm tra POST request** (actual)
5. **Xem response headers** của cả 2 requests
6. **Kiểm tra server logs** để xem có nhận được request không

## ✅ **Expected result:**

```
✅ OPTIONS /api/chat 200 OK
   Access-Control-Allow-Origin: https://api.muvietplus.net
   Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS
   Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, Accept

✅ POST /api/chat 200 OK
   Content-Type: application/json
   {"success": true, "message": "..."}
```
