# 🚀 Hướng dẫn Deploy ChatBot GPT

## 📋 **Vấn đề hiện tại:**
- CORS error khi truy cập từ `https://api.muvietplus.net` tới `https://kthcdemo.muvietplus.net`
- Server chưa được deploy đúng cách

## 🎯 **Giải pháp:**

### **Cách 1: Deploy Server lên kthcdemo.muvietplus.net**

1. **Upload server files lên hosting:**
```bash
# Files cần upload:
- server-new.js
- package.json
- config/
- middleware/
- api/
- utils/
- .env (nếu có)
```

2. **Cài đặt dependencies:**
```bash
npm install
```

3. **Start server:**
```bash
npm start
# hoặc
node server-new.js
```

### **Cách 2: Sử dụng cùng domain (Khuyến nghị)**

Nếu cả frontend và backend đều ở `api.muvietplus.net`:

1. **Sửa BASE_URL trong chatbot-widget.js:**
```javascript
BASE_URL: 'https://api.muvietplus.net'
```

2. **Deploy server lên api.muvietplus.net**

### **Cách 3: Sử dụng localhost cho development**

1. **Start server local:**
```bash
npm start
```

2. **Sửa BASE_URL tạm thời:**
```javascript
BASE_URL: 'http://localhost:3000'
```

## 🔧 **Cấu hình CORS:**

Server đã được cấu hình CORS cho các domain:
- `https://api.muvietplus.net`
- `https://kthcdemo.muvietplus.net`
- `https://muvietplus.net`
- `https://www.muvietplus.net`
- Localhost

## 🧪 **Test:**

1. **Test server:**
```bash
curl https://kthcdemo.muvietplus.net/api/test
```

2. **Test từ browser:**
- Mở `public/server-test.html`
- Click test buttons

3. **Test ChatBot:**
- Mở `public/widget-js-demo.html`
- Kiểm tra console logs

## 📁 **Cấu trúc files:**

```
ChatBot-GPT/
├── public/                    # Frontend files
│   ├── chatbot-widget.js     # Widget JS
│   ├── widget-js-demo.html   # Demo page
│   └── server-test.html      # Test tool
├── server-new.js             # Main server
├── api/                      # API routes
├── config/                   # Config files
├── middleware/               # Middleware
└── utils/                    # Utilities
```

## 🌐 **URLs:**

- **Frontend Demo:** `https://api.muvietplus.net/kthcdemo/`
- **Server API:** `https://kthcdemo.muvietplus.net/api/`
- **Test Tool:** `https://api.muvietplus.net/kthcdemo/server-test.html`

## ⚠️ **Lưu ý:**

1. **Port:** Server chạy trên port 3000 (có thể thay đổi trong .env)
2. **CORS:** Đã cấu hình cho cross-origin requests
3. **SSL:** Cần HTTPS cho production
4. **Environment:** Kiểm tra .env file cho API keys
