# 🤖 ChatBot GPT - Widget Tích Hợp KTHC

ChatBot sử dụng OpenAI Assistant API với widget tối giản, tích hợp API KTHC để tạo lương, bảo hiểm, công đoàn.

## 📁 Cấu Trúc Dự Án (Project Structure)

```
ChatBot-GPT/
├── 📄 server-new.js              # Server chính (151 lines)
├── 📄 package.json               # Dependencies
├── 📄 env.example                # Template environment variables
├── 📄 README.md                  # Tài liệu chính
├── 📄 key.txt                    # API keys
├── 📁 api/                       # API Modules
│   ├── 📁 ctgs/                  # Chi tiết giao sổ (CTGS)
│   │   ├── ctgsRoutes.js         # Routes cho CTGS
│   │   └── ctgsService.js        # Business logic CTGS
│   ├── 📁 taoluong/              # Tạo lương
│   │   ├── luongRoutes.js        # Routes tạo lương
│   │   └── luongService.js       # Business logic lương
│   ├── 📁 taobaohiem/            # Tạo bảo hiểm
│   │   ├── baoHiemRoutes.js      # Routes bảo hiểm
│   │   └── baoHiemService.js     # Business logic bảo hiểm
│   └── 📁 taocongdoan/           # Tạo công đoàn
│       ├── congDoanRoutes.js     # Routes công đoàn
│       └── congDoanService.js    # Business logic công đoàn
├── 📁 config/                    # Cấu hình hệ thống
│   ├── database.js               # Quản lý session và database
│   ├── openai.js                 # Cấu hình OpenAI
│   └── kthc.js                   # Cấu hình API KTHC
├── 📁 middleware/                # Middleware
│   ├── apiMiddleware.js          # Middleware API validation
│   └── sessionMiddleware.js      # Middleware session management
├── 📁 utils/                     # Tiện ích
│   ├── apiHelper.js              # Helper cho API calls
│   ├── chatGPTService.js         # Service ChatGPT
│   └── responseHelper.js         # Helper format response
├── 📁 public/                    # Frontend files
│   ├── index.html                # Trang chính
│   ├── chatbot-widget.js         # Widget chính (3302 lines)
│   ├── widget-js-demo.html       # Demo page (888 lines)
│   ├── INTEGRATION-GUIDE.md      # Hướng dẫn tích hợp
│   ├── styles.css                # CSS styles
│   └── script.js                 # JavaScript logic
├── 📁 rag/                       # RAG & QA System
│   ├── index.html                # RAG data template
│   ├── qa-test.html              # QA test interface
│   ├── qa-database.json          # QA database
│   └── qa-search.js              # QA search engine
└── 📁 logs/                      # Log files
```

## 🔄 Luồng Dữ Liệu Từ Widget (Data Flow from Widget)

### 📊 **Tổng Quan Luồng (Flow Overview)**

```
Client (Widget) → Server → KTHC API → Response → Client
```

### 🎯 **Chi Tiết Luồng Xử Lý (Detailed Processing Flow)**

#### **1. Khởi Tạo Widget (Widget Initialization)**
```javascript
// public/chatbot-widget.js
const SERVER_CONFIG = {
    BASE_URL: 'http://localhost:3000',
    ENDPOINTS: {
        CHAT: '/api/chat',
        CTGS_CREATE: '/api/ctgs/create',
        CTGS_LIST: '/api/ctgs/list',
        LUONG: '/api/luong',
        BAOHIEM: '/api/baohiem',
        CONGDOAN: '/api/congdoan'
    }
};
```

#### **2. Client → Server (Client đến Server)**
- **Widget** gửi message qua `fetch()`
- **URL**: `SERVER_CONFIG.BASE_URL + SERVER_CONFIG.ENDPOINTS.CHAT`
- **Method**: `POST`
- **Payload**: `{ message, sessionId, isApiCall, apiParams }`

#### **3. Server Processing (Xử lý server)**
```javascript
// server-new.js
app.post('/api/chat', sessionMiddleware, async (req, res) => {
    const { message, isApiCall } = req.body;
    
    if (isApiCall) {
        // Xử lý API calls thực tế
        switch (message) {
            case 'Tạo lương tháng':
                return await taoLuongvoiCTGS(req, res);
            case 'Tạo bảo hiểm tháng':
                return await taoBaohiem(req, res);
            case 'Tạo kinh phí công đoàn tháng':
                return await taoCongdoan(req, res);
        }
    } else {
        // Xử lý ChatGPT
        return await xulyBotGPT(req, res);
    }
});
```

#### **4. API Processing Flow**

##### **4.1. Tạo Lương Tháng (Create Monthly Salary)**
```
1. taoLuongvoiCTGS() → api/taoluong/luongService.js
2. layDanhsachCTGS() → api/ctgs/ctgsService.js
3. KTHC API Call → config/kthc.js
4. Response Processing → utils/responseHelper.js
```

##### **4.2. Tạo CTGS Mới (Nếu Cần) (Create New CTGS if Needed)**
```
1. Client Form Submit → public/chatbot-widget.js
2. createCTGS() → SERVER_CONFIG.BASE_URL/api/ctgs/create
3. taoCTGSMoi() → api/ctgs/ctgsService.js
4. KTHC API Post → config/kthc.js
5. Success Response → Auto reload lương
```

#### **5. KTHC API Integration**

##### **5.1. Cấu Hình API (API Configuration)**
```javascript
// config/kthc.js
const KTHC_CONFIG = {
    baseUrl: 'https://kthcdemoapi.dtsoft.vn/api',
    userAgent: 'Mozilla/5.0 ... ChatBot/1.0'
};

const KTHC_ENDPOINTS = {
    layCtgs: '/Ctgs/Get',
    taoCTGS: '/Ctgs/Post',
    taoLuong: '/LuongThang/Post',
    taoBaoHiem: '/BaoHiem/Post',
    taoCongDoan: '/CongDoan/Post'
};
```

##### **5.2. Authentication & Headers (Xác thực và tiêu đề)**
```javascript
function taoHeaders(token) {
    return {
        'accept': 'application/json',
        'Authorization': `Bearer ${token}`,
        'User-Agent': KTHC_CONFIG.userAgent,
        'Content-Type': 'application/json'
    };
}
```

#### **6. Data Flow Sequence (Trình tự luồng dữ liệu)**

```mermaid
sequenceDiagram
    participant C as Client Widget
    participant S as Server
    participant K as KTHC API
    participant L as LocalStorage
    
    C->>L: Lấy apiParams (token, mã cơ quan, etc.)
    C->>S: POST /api/chat (Tạo lương tháng)
    S->>K: GET /Ctgs/Get (Lấy danh sách CTGS)
    K-->>S: Response CTGS list
    
    alt CTGS có sẵn
        S-->>C: Hiển thị danh sách CTGS để chọn
        C->>S: POST /api/ctgs/create (Chọn CTGS)
        S->>K: POST /LuongThang/Post
        K-->>S: Response thành công
        S-->>C: Hiển thị kết quả
    else Chưa có CTGS
        S-->>C: Hiển thị form tạo CTGS
        C->>S: POST /api/ctgs/create (Dữ liệu CTGS mới)
        S->>K: POST /Ctgs/Post
        K-->>S: Response CTGS ID
        S-->>C: Tự động chuyển sang tạo lương
    end
```

#### **7. Client-Side Data Management (Quản lý dữ liệu phía client)**

##### **7.1. LocalStorage Structure (Cấu trúc lưu trữ cục bộ)**
```javascript
{
    "user": "1126220_KTV2",
    "token_httc": "eyJhbGciOiJIUzUxMi...",
    "kthcMaCoQuan": 73,
    "kthcMaCanBo": 104,
    "kthcNam": 2026,
    "kthcThang": 12,
    "kthcTenCoQuan": "Trường THCS Test",
    "kthcMSQHNS": "1126220",
    "kthcplgd": "KH-CB",
    "kthcIdvunglv": 68,
    "kthcNlb": "Võ Lập Biểu",
    "kthcPtkt": "Nguyễn Kế Toán"
}
```

##### **7.2. API Configuration Management (Quản lý cấu hình API)**
```javascript
// Lấy dữ liệu từ localStorage
function getApiData() {
    const savedData = localStorage.getItem('chatbot_api_data');
    return savedData ? JSON.parse(savedData) : {};
}

// Lưu dữ liệu vào localStorage
function setApiData(data) {
    localStorage.setItem('chatbot_api_data', JSON.stringify(data));
}
```

#### **8. Response Handling**

##### **8.1. Success Response Types (Các loại phản hồi thành công)**
```javascript
// utils/responseHelper.js
{
    type: 'success',
    message: 'Tạo lương thành công!',
    data: { /* result data */ }
}

{
    type: 'ctgs_selection',
    message: 'Chọn CTGS để tạo lương',
    data: { ctgsList: [...] }
}

{
    type: 'ctgs_create_form',
    message: 'Tạo CTGS mới',
    data: { formHtml: '...' }
}
```

##### **8.2. Error Handling (Xử lý lỗi)**
```javascript
{
    type: 'error',
    message: 'Lỗi chi tiết...',
    data: { 
        errorCode: 'API_ERROR',
        details: '...'
    }
}
```

## 🚀 Cài Đặt & Chạy (Installation & Running)

### **1. Cài Đặt (Installation)**
```bash
# Clone repository
git clone <repository-url>
cd ChatBot-GPT

# Cài đặt dependencies
npm install
```

### **2. Cấu Hình Environment (Environment Configuration)**
```bash
# Copy file example
cp env.example .env

# Chỉnh sửa .env với các API key
OPENAI_API_KEY=your_openai_api_key
ASSISTANT_ID=asst_0nXp6vSvvGMUjNUjcX3NVUGa
VECTOR_STORE_ID=vs_68a57ca699c88191a21350a70657848d
MAX_COMPLETION_TOKENS=200
PORT=3000
```

### **3. Khởi Động Server (Start Server)**
```bash
# Development
node server-new.js

# Production với PM2
pm2 start server-new.js --name "chatbot-gpt"
```

## 🌐 Sử Dụng & Demo (Usage & Demo)

### **Các URL Chính (Main URLs)**
- **Trang chính:** `http://localhost:3000`
- **Widget demo:** `http://localhost:3000/widget-js-demo.html`
- **RAG system:** `http://localhost:3000/rag/`

### **API Endpoints (Các điểm cuối API)**
- `POST /api/chat` - Chat chính & API calls
- `POST /api/ctgs/create` - Tạo CTGS mới
- `GET /api/ctgs/list` - Lấy danh sách CTGS
- `POST /api/luong` - Tạo lương
- `POST /api/baohiem` - Tạo bảo hiểm
- `POST /api/congdoan` - Tạo công đoàn

## 🔧 Tính Năng Chính (Main Features)

### **ChatBot Core (Lõi ChatBot)**
- ✅ OpenAI Assistant API
- ✅ Session management
- ✅ Responsive design
- ✅ Mobile friendly
- ✅ Tabbed interface (Tạo chứng từ / Tra cứu)

### **KTHC Integration (Tích hợp KTHC)**
- ✅ Tạo lương tháng
- ✅ Tạo bảo hiểm tháng  
- ✅ Tạo kinh phí công đoàn tháng
- ✅ Quản lý CTGS (Chi tiết giao sổ)
- ✅ Dynamic form creation
- ✅ Auto parameter filling

### **Widget Features (Tính năng Widget)**
- ✅ Centralized server URL config
- ✅ Cross-domain compatibility
- ✅ Real-time form interaction
- ✅ LocalStorage integration
- ✅ Error handling & validation

## 🔧 Nhúng Widget Vào Website Khác (Embed Widget to Other Websites)

### **Cách 1: Iframe (Đơn giản) (Simple)**
```html
<iframe 
    src="http://localhost:3000/widget-js-demo.html"
    style="position: fixed; bottom: 20px; right: 20px; width: 400px; height: 600px; border: none; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.3); z-index: 1000;">
</iframe>
```

### **Cách 2: JavaScript API (Nâng cao) (Advanced)**
```html
<!-- Include widget script -->
<script src="http://localhost:3000/chatbot-widget.js"></script>

<!-- Configure widget -->
<script>
window.setChatbotConfig({
    apiUrl: 'http://localhost:3000/api/chat',
    position: 'bottom-right',
    theme: 'default'
});
</script>
```

### **Cách 3: Server URL Configuration (Cấu hình URL Server)**
```javascript
// Thay đổi server URL cho cross-domain
window.setServerUrl('https://your-server.com');

// Lấy URL hiện tại
const currentUrl = window.getServerUrl();

// Lấy endpoint URL đầy đủ
const chatUrl = window.getApiUrl('CHAT');
```

## 📚 Documentation (Tài liệu)

- **[Integration Guide](public/INTEGRATION-GUIDE.md)** - Hướng dẫn nhúng widget chi tiết (Integration Guide)
- **[API Documentation](#api-endpoints)** - Chi tiết các API endpoints (API Documentation)
- **[Configuration Guide](#cấu-hình-environment)** - Hướng dẫn cấu hình (Configuration Guide)

## 🚀 Deployment (Triển khai)

### **cPanel (Shared Hosting) (Hosting chia sẻ)**
1. Upload files lên public_html
2. Cấu hình Node.js Selector
3. Chạy `npm install --production`
4. Khởi động ứng dụng với `server-new.js`

### **VPS/Dedicated (Máy chủ ảo/Chuyên dụng)**
1. Clone repository
2. Cài đặt dependencies
3. Cấu hình environment
4. Sử dụng PM2 hoặc systemd

### **Docker (Optional) (Tùy chọn)**
```dockerfile
FROM node:18-alpine
WORKDIR /app
COPY package*.json ./
RUN npm install --production
COPY . .
EXPOSE 3000
CMD ["node", "server-new.js"]
```

## 🔍 Troubleshooting (Gỡ lỗi)

### **Common Issues (Các vấn đề thường gặp)**
1. **CORS Error**: Cấu hình `cors()` trong server
2. **API Token Invalid**: Kiểm tra token trong localStorage
3. **CTGS Not Found**: Tạo CTGS mới qua form
4. **Unicode Characters**: Server tự động xử lý encoding

### **Debug Tools (Công cụ gỡ lỗi)**
- Browser Developer Console
- Server logs trong thư mục `logs/`
- Network tab để theo dõi API calls

## 📄 License

MIT License

## 🤝 Support

Nếu có vấn đề, vui lòng tạo issue hoặc liên hệ support.

---

**Phiên bản:** 2.0  
**Cập nhật:** Tháng 12/2024  
**Tương thích:** Node.js 16+, Modern browsers

## 🔄 Luồng Xử Lý Dữ Liệu Chi Tiết (Detailed Data Processing Flow)

### 📊 **Tổng Quan Luồng Nghiệp Vụ (Business Flow Overview)**

```
User Input → Widget → Server → Business Logic → External API → Response → UI
```

### 🎯 **Chi Tiết Luồng Theo Từng Nghiệp Vụ**

#### **1. Nghiệp Vụ: Tạo Lương Tháng (Create Monthly Salary)**

##### **1.1. Luồng Xử Lý:**
```
1. User Input: "Tạo lương tháng"
   ↓
2. public/chatbot-widget.js
   - Function: sendMessageWithFlag()
   - Xử lý: Gửi message với flag isApiCall = true
   ↓
3. server-new.js (Line 45-60)
   - Route: POST /api/chat
   - Middleware: sessionMiddleware
   - Logic: Switch case "Tạo lương tháng"
   ↓
4. api/taoluong/luongService.js
   - Function: taoLuongvoiCTGS()
   - Xử lý: Kiểm tra và lấy danh sách CTGS
   ↓
5. api/ctgs/ctgsService.js
   - Function: layDanhsachCTGS()
   - Xử lý: Gọi KTHC API lấy danh sách CTGS
   ↓
6. config/kthc.js
   - Function: guiGetRequest()
   - Endpoint: /Ctgs/Get
   - Xử lý: Authentication và API call
   ↓
7. utils/apiHelper.js
   - Function: guiApiRequest()
   - Xử lý: HTTP request với headers và error handling
   ↓
8. utils/responseHelper.js
   - Function: dinhdanhCTGSSelectionResponse()
   - Xử lý: Format response cho UI
   ↓
9. public/chatbot-widget.js
   - Function: handleResponse()
   - Xử lý: Hiển thị danh sách CTGS cho user chọn
```

##### **1.2. Các File Tham Gia:**
| **File** | **Chức Năng** | **Input** | **Output** |
|----------|---------------|-----------|------------|
| `public/chatbot-widget.js` | Gửi request từ UI | User message | POST request |
| `server-new.js` | Route handler | POST request | Call business logic |
| `api/taoluong/luongService.js` | Business logic lương | Request data | CTGS list request |
| `api/ctgs/ctgsService.js` | Business logic CTGS | User info | KTHC API call |
| `config/kthc.js` | KTHC API config | API params | HTTP request |
| `utils/apiHelper.js` | HTTP helper | API config | Raw response |
| `utils/responseHelper.js` | Format response | Raw data | Formatted UI data |
| `public/chatbot-widget.js` | Display UI | Formatted data | User interface |

#### **2. Nghiệp Vụ: Tạo CTGS Mới (Create New CTGS)**

##### **2.1. Luồng Xử Lý:**
```
1. User Input: Form CTGS data
   ↓
2. public/chatbot-widget.js
   - Function: createCTGS()
   - Xử lý: Thu thập form data và gửi request
   ↓
3. server-new.js (Line 80-85)
   - Route: POST /api/ctgs/create
   - Middleware: sessionMiddleware
   ↓
4. api/ctgs/ctgsRoutes.js
   - Route handler: POST /create
   - Xử lý: Validate input và gọi service
   ↓
5. api/ctgs/ctgsService.js
   - Function: taoCTGSMoi()
   - Xử lý: Format data và gọi KTHC API
   ↓
6. config/kthc.js
   - Function: guiPostRequest()
   - Endpoint: /Ctgs/Post
   - Xử lý: POST request với form data
   ↓
7. utils/apiHelper.js
   - Function: guiApiRequest()
   - Xử lý: URL encoding cho Unicode characters
   ↓
8. utils/responseHelper.js
   - Function: dinhdanhResponseThanhcong()
   - Xử lý: Success message và auto reload
   ↓
9. public/chatbot-widget.js
   - Function: handleCTGSSuccess()
   - Xử lý: Hiển thị success và tự động tạo lương
```

##### **2.2. Các File Tham Gia:**
| **File** | **Chức Năng** | **Input** | **Output** |
|----------|---------------|-----------|------------|
| `public/chatbot-widget.js` | Form submission | Form data | POST request |
| `server-new.js` | Route handler | POST request | Call CTGS routes |
| `api/ctgs/ctgsRoutes.js` | CTGS routes | Request data | Call CTGS service |
| `api/ctgs/ctgsService.js` | CTGS business logic | Form data | KTHC API call |
| `config/kthc.js` | KTHC API config | CTGS data | HTTP POST request |
| `utils/apiHelper.js` | HTTP helper | API config | Raw response |
| `utils/responseHelper.js` | Format response | Raw data | Success message |
| `public/chatbot-widget.js` | Success handling | Success data | Auto reload lương |

#### **3. Nghiệp Vụ: Tạo Bảo Hiểm Tháng (Create Monthly Insurance)**

##### **3.1. Luồng Xử Lý:**
```
1. User Input: "Tạo bảo hiểm tháng"
   ↓
2. public/chatbot-widget.js
   - Function: sendMessageWithFlag()
   - Xử lý: Gửi message với flag isApiCall = true
   ↓
3. server-new.js (Line 45-60)
   - Route: POST /api/chat
   - Logic: Switch case "Tạo bảo hiểm tháng"
   ↓
4. api/taobaohiem/baoHiemService.js
   - Function: taoBaohiem()
   - Xử lý: Validate user info và gọi KTHC API
   ↓
5. config/kthc.js
   - Function: guiPostRequest()
   - Endpoint: /BaoHiem/Post
   - Xử lý: Authentication và API call
   ↓
6. utils/apiHelper.js
   - Function: guiApiRequest()
   - Xử lý: HTTP request với error handling
   ↓
7. utils/responseHelper.js
   - Function: dinhdanhResponseThanhcong()
   - Xử lý: Format success response
   ↓
8. public/chatbot-widget.js
   - Function: handleResponse()
   - Xử lý: Hiển thị kết quả tạo bảo hiểm
```

##### **3.2. Các File Tham Gia:**
| **File** | **Chức Năng** | **Input** | **Output** |
|----------|---------------|-----------|------------|
| `public/chatbot-widget.js` | Send request | User message | POST request |
| `server-new.js` | Route handler | POST request | Call bảo hiểm service |
| `api/taobaohiem/baoHiemService.js` | Bảo hiểm business logic | User info | KTHC API call |
| `config/kthc.js` | KTHC API config | API params | HTTP request |
| `utils/apiHelper.js` | HTTP helper | API config | Raw response |
| `utils/responseHelper.js` | Format response | Raw data | Success message |
| `public/chatbot-widget.js` | Display result | Success data | User interface |

#### **4. Nghiệp Vụ: Tạo Công Đoàn Tháng (Create Monthly Union Fee)**

##### **4.1. Luồng Xử Lý:**
```
1. User Input: "Tạo kinh phí công đoàn tháng"
   ↓
2. public/chatbot-widget.js
   - Function: sendMessageWithFlag()
   - Xử lý: Gửi message với flag isApiCall = true
   ↓
3. server-new.js (Line 45-60)
   - Route: POST /api/chat
   - Logic: Switch case "Tạo kinh phí công đoàn tháng"
   ↓
4. api/taocongdoan/congDoanService.js
   - Function: taoCongdoan()
   - Xử lý: Validate user info và gọi KTHC API
   ↓
5. config/kthc.js
   - Function: guiPostRequest()
   - Endpoint: /CongDoan/Post
   - Xử lý: Authentication và API call
   ↓
6. utils/apiHelper.js
   - Function: guiApiRequest()
   - Xử lý: HTTP request với error handling
   ↓
7. utils/responseHelper.js
   - Function: dinhdanhResponseThanhcong()
   - Xử lý: Format success response
   ↓
8. public/chatbot-widget.js
   - Function: handleResponse()
   - Xử lý: Hiển thị kết quả tạo công đoàn
```

##### **4.2. Các File Tham Gia:**
| **File** | **Chức Năng** | **Input** | **Output** |
|----------|---------------|-----------|------------|
| `public/chatbot-widget.js` | Send request | User message | POST request |
| `server-new.js` | Route handler | POST request | Call công đoàn service |
| `api/taocongdoan/congDoanService.js` | Công đoàn business logic | User info | KTHC API call |
| `config/kthc.js` | KTHC API config | API params | HTTP request |
| `utils/apiHelper.js` | HTTP helper | API config | Raw response |
| `utils/responseHelper.js` | Format response | Raw data | Success message |
| `public/chatbot-widget.js` | Display result | Success data | User interface |

### 🔧 **Middleware và Utilities**

#### **5. Middleware Processing (Xử lý middleware)**

##### **5.1. Session Middleware:**
```
1. Request đến server
   ↓
2. middleware/sessionMiddleware.js
   - Function: sessionMiddleware()
   - Xử lý: Kiểm tra và tạo session
   ↓
3. config/database.js
   - Function: taiSessionTuFile()
   - Xử lý: Load session từ file
   ↓
4. Request tiếp tục với session data
```

##### **5.2. API Middleware:**
```
1. API request
   ↓
2. middleware/apiMiddleware.js
   - Function: kiemtraApiMiddleware()
   - Xử lý: Validate API parameters
   ↓
3. config/kthc.js
   - Function: layThongtinUser()
   - Xử lý: Extract user info từ params
   ↓
4. Request tiếp tục với validated data
```

#### **6. Error Handling Flow (Luồng xử lý lỗi)**

##### **6.1. API Error:**
```
1. KTHC API trả về lỗi
   ↓
2. utils/apiHelper.js
   - Function: guiApiRequest()
   - Xử lý: Catch HTTP errors
   ↓
3. utils/responseHelper.js
   - Function: dinhdanhResponseLoi()
   - Xử lý: Format error message
   ↓
4. public/chatbot-widget.js
   - Function: handleError()
   - Xử lý: Hiển thị lỗi cho user
```

##### **6.2. Validation Error:**
```
1. Invalid input data
   ↓
2. middleware/apiMiddleware.js
   - Function: kiemtraApiMiddleware()
   - Xử lý: Validate required fields
   ↓
3. utils/responseHelper.js
   - Function: dinhdanhResponseLoi()
   - Xử lý: Format validation error
   ↓
4. public/chatbot-widget.js
   - Function: handleError()
   - Xử lý: Hiển thị validation error
```

### 📊 **Data Transformation Flow (Luồng chuyển đổi dữ liệu)**

#### **7. LocalStorage → API Params:**
```
1. public/chatbot-widget.js
   - Function: getApiData()
   - Input: localStorage keys
   - Output: API parameters object
   ↓
2. server-new.js
   - Function: Extract apiParams
   - Input: Request body
   - Output: User info object
   ↓
3. config/kthc.js
   - Function: layThongtinUser()
   - Input: API params
   - Output: Formatted user info
```

#### **8. KTHC Response → UI Data:**
```
1. utils/apiHelper.js
   - Function: guiApiRequest()
   - Input: Raw KTHC response
   - Output: Parsed JSON data
   ↓
2. utils/responseHelper.js
   - Function: dinhdanhResponseThanhcong()
   - Input: Parsed data
   - Output: Formatted UI response
   ↓
3. public/chatbot-widget.js
   - Function: handleResponse()
   - Input: Formatted response
   - Output: User interface
```

### 🎯 **Key Functions và Responsibilities**

| **File** | **Key Functions** | **Responsibilities** |
|----------|------------------|---------------------|
| `public/chatbot-widget.js` | `sendMessageWithFlag()`, `createCTGS()`, `handleResponse()` | UI interaction, form handling, response display |
| `server-new.js` | Route handlers, switch cases | Request routing, business logic coordination |
| `api/*/Service.js` | `taoLuongvoiCTGS()`, `taoBaohiem()`, `taoCongdoan()` | Business logic, data validation, API coordination |
| `config/kthc.js` | `guiGetRequest()`, `guiPostRequest()`, `taoHeaders()` | KTHC API integration, authentication, request formatting |
| `utils/apiHelper.js` | `guiApiRequest()`, error handling | HTTP requests, error management, response parsing |
| `utils/responseHelper.js` | `dinhdanhResponseThanhcong()`, `dinhdanhResponseLoi()` | Response formatting, UI data preparation |
| `middleware/*.js` | `sessionMiddleware()`, `kiemtraApiMiddleware()` | Request validation, session management, data preprocessing |

---