const express = require('express');
const router = express.Router();
const { layDanhsachCTGS, layIDCTGSMax, taoCTGSMoi } = require('./ctgsService');
const { layThongtinUser } = require('../../config/kthc');

// GET /api/ctgs/list - Lấy danh sách CTGS
router.get('/list', async (req, res) => {
  try {
    const userInfo = layThongtinUser(req.query);
    const result = await layDanhsachCTGS(userInfo);
    res.json(result);
  } catch (error) {
    res.status(500).json({
      success: false,
      error: error.message
    });
  }
});

// POST /api/ctgs/list - Lấy danh sách CTGS (POST method)
router.post('/list', async (req, res) => {
  try {
    const userInfo = layThongtinUser(req.body);
    const result = await layDanhsachCTGS(userInfo);
    res.json(result);
  } catch (error) {
    res.status(500).json({
      success: false,
      error: error.message
    });
  }
});

// GET /api/ctgs/getidctgsmax - Lấy IDCTGS max
router.get('/getidctgsmax', async (req, res) => {
  try {
    const userInfo = layThongtinUser(req.query);
    const result = await layIDCTGSMax(userInfo);
    res.json(result);
  } catch (error) {
    res.status(500).json({
      success: false,
      error: error.message
    });
  }
});

// POST /api/ctgs/create - Tạo CTGS mới
router.post('/create', async (req, res) => {
  try {
    const userInfo = layThongtinUser(req.body);
    const ctgsData = req.body.ctgsData || {};
    const result = await taoCTGSMoi(userInfo, ctgsData);
    res.json(result);
  } catch (error) {
    res.status(500).json({
      success: false,
      error: error.message
    });
  }
});

module.exports = router;
