const { guiYeuCauGet, guiYeuCauPost, ghiLogHieuNangApi, dinhDangThongBaoLoi } = require('../../utils/apiHelper');
const { dinhDangPhanHoiFormCTGS } = require('../../utils/responseHelper');
const { KTHC_ENDPOINTS } = require('../../config/kthc');

// Get CTGS list
async function layDanhsachCTGS(userInfo) {
  const startTime = Date.now();
  
  try {
    console.log('📋 Bước 2: Lấy danh sách CTGS...');
    
    // Debug thông tin userInfo
    console.log('🔍 Debug userInfo cho CTGS:', {
      kthcMaCoQuan: userInfo.kthcMaCoQuan,
      kthcMaCanBo: userInfo.kthcMaCanBo,
      kthcNam: userInfo.kthcNam,
      kthcplgd: userInfo.kthcplgd
    });
    
    // Sử dụng năm từ userInfo thay vì hardcode
    console.log('🔧 Sử dụng năm từ userInfo:', userInfo.kthcNam);
    const namCTGS = userInfo.kthcNam;
    
    // Thêm timestamp để tránh cache
    const timestamp = Date.now();
    const params = {
      skip: 0,
      take: 20,
      requireTotalCount: true,
      sort: '[{"selector":"Idctgs","desc":true}]',
      MaCoQuan: userInfo.kthcMaCoQuan,
      MaCanBo: userInfo.kthcMaCanBo,
      Nam: namCTGS,
      PLGD: userInfo.kthcplgd,
      _: timestamp
    };
    
    const ctgsResult = await guiYeuCauGet(KTHC_ENDPOINTS.getCTGS, params, userInfo.token_httc);
    
    console.log('📋 Danh sách CTGS:', JSON.stringify(ctgsResult, null, 2));
    
    // Kiểm tra cấu trúc response - response có dạng { data: [...], totalCount: 2 }
    let ctgsList = ctgsResult?.data || [];
    let totalCount = ctgsResult?.totalCount || 0;
    
    console.log('🔍 Cấu trúc response:', {
      hasData: !!ctgsResult.data,
      dataLength: ctgsResult.data ? ctgsResult.data.length : 0,
      totalCount: totalCount,
      responseKeys: Object.keys(ctgsResult)
    });
    
    if (!ctgsList || ctgsList.length === 0) {
      console.log('⚠️ Không tìm thấy CTGS nào trong danh sách');
      console.log('💡 Hiển thị form tạo CTGS mới...');
      console.log('🔍 Thông tin tìm kiếm:', {
        MaCoQuan: userInfo.kthcMaCoQuan,
        MaCanBo: userInfo.kthcMaCanBo,
        Nam: userInfo.kthcNam,
        PLGD: userInfo.kthcplgd
      });
      
      // Trả về form tạo CTGS mới
      ghiLogHieuNangApi(startTime, 'Get CTGS List', true);
      
      const formData = {
        MaCoQuan: userInfo.kthcMaCoQuan,
        MaCanBo: userInfo.kthcMaCanBo,
        Nam: userInfo.kthcNam,
        Ntctgs: new Date().toISOString().split('T')[0], // Ngày hiện tại
        Shctgs: '', // Số hiệu - bắt buộc nhập
        Plctgs: 'Dự toán', // Phân loại - mặc định
        Sgctgs: 0, // Số CT
        Nlctgs: '', // Lập biểu
        Ktctgs: '', // Kế toán
        Dcctgs: 'Có' // CT ghi sổ - mặc định
      };
      
      const options = {
        plctgs: ['Dự toán', 'Hoạt động', 'Hoạt động khác', 'Tài sản', 'KC'],
        dcctgs: ['Có', 'Không']
      };
      
      return dinhDangPhanHoiFormCTGS(formData, options, userInfo);
    }
    
    // Lấy thông tin chi tiết hạch toán độc lập
    console.log('🔍 Lấy thông tin chi tiết hạch toán...');
    
    let accountingDetails = null;
    
    try {
      // Gọi API để lấy dữ liệu chi tiết hạch toán
      const detailParams = {
        skip: 0,
        take: 10,
        requireTotalCount: true,
        sort: '[{"selector":"Sghi","desc":true}]',
        totalSummary: '[{"selector":"Dst","summaryType":"sum"},{"selector":"Num5","summaryType":"sum"},{"selector":"Dmct","summaryType":"sum"}]',
        Idnhom: userInfo.idnhom,
        _: Date.now()
      };
      
      console.log('📊 Lấy chi tiết hạch toán với Idnhom:', userInfo.idnhom);
      
             const detailResult = await guiYeuCauGet(KTHC_ENDPOINTS.getChiTietHachToan, detailParams, userInfo.token_httc);
       
       console.log(' Chi tiết hạch toán:', {
         totalCount: detailResult?.totalCount || 0,
         summary: detailResult?.summary || [],
         data: detailResult?.data || []
       });
       
       // Lưu thông tin chi tiết hạch toán
       accountingDetails = {
         totalCount: detailResult?.totalCount || 0,
         summary: detailResult?.summary || [],
         data: detailResult?.data || []
       };
    } catch (error) {
      console.log('❌ Lỗi lấy chi tiết hạch toán:', error.message);
    }
    
         // Sử dụng ctgsList gốc
     const ctgsWithDetails = ctgsList || [];
     
     // Trả về danh sách CTGS cho user chọn
     console.log('📋 Tìm thấy', ctgsWithDetails.length, 'CTGS với chi tiết, trả về cho user chọn...');
     
     const ctgsOptions = ctgsWithDetails.map((ctgs, index) => ({
      id: ctgs.Idctgs,
      index: index + 1,
      ngayTao: new Date(ctgs.Ntctgs).toLocaleDateString('vi-VN'),
      soHieu: ctgs.Shctgs,
      phanLoai: ctgs.Plctgs || 'Không có',
      keToan: ctgs.Ktctgs,
      nguoiLap: ctgs.Nlctgs,
      soGoc: ctgs.Sgctgs,
      smtm: ctgs.smtm || null,
      dst: ctgs.dst || null,
      smn: ctgs.smn || null,
      totalAmount: ctgs.totalAmount || 0
    }));
    
    ghiLogHieuNangApi(startTime, 'Get CTGS List', true);
    
         return {
       success: true,
       data: {
         type: 'ctgs_selection',
         ctgsList: ctgsOptions,
         totalCount: totalCount,
         accountingDetails: accountingDetails,
         userInfo: {
           kthcMaCoQuan: userInfo.kthcMaCoQuan,
           kthcMaCanBo: userInfo.kthcMaCanBo,
           kthcNam: userInfo.kthcNam
         }
       }
     };
    
  } catch (error) {
    ghiLogHieuNangApi(startTime, 'Get CTGS List', false);
    
    // Nếu error message đã có format chi tiết, giữ nguyên
    if (error.message && error.message.includes('❌ **Chưa tạo CTGS')) {
      throw error;
    }
    
    // Nếu không, format lại bằng dinhDangThongBaoLoi
    throw new Error(dinhDangThongBaoLoi(error, 'Lấy danh sách CTGS'));
  }
}

// Get IDCTGS max
async function layIDCTGSMax(userInfo) {
  const startTime = Date.now();
  
  try {
    console.log('📋 Lấy IDCTGS max...');
    
    const params = {
      MaCoQuan: userInfo.kthcMaCoQuan,
      MaCanBo: userInfo.kthcMaCanBo,
      Nam: userInfo.kthcNam,
      PLGD: userInfo.kthcplgd
    };
    
    const result = await guiYeuCauGet(KTHC_ENDPOINTS.getIDCTGSMax, params, userInfo.token_httc);
    
    console.log('📊 IDCTGS Max Result:', JSON.stringify(result, null, 2));
    
    ghiLogHieuNangApi(startTime, 'Get IDCTGS Max', true);
    
    return {
      success: true,
      data: {
        idctgsMax: result.data || result
      }
    };
    
  } catch (error) {
    ghiLogHieuNangApi(startTime, 'Get IDCTGS Max', false);
    throw new Error(dinhDangThongBaoLoi(error, 'Lấy IDCTGS max'));
  }
}

// Tạo CTGS mới
async function taoCTGSMoi(userInfo, ctgsData = {}) {
  const startTime = Date.now();
  
  try {
    console.log('📋 Tạo CTGS mới...');
    
    // Dữ liệu mặc định cho CTGS
    const defaultCTGSData = {
      Ntctgs: new Date().toISOString(),
      MaCoQuan: userInfo.kthcMaCoQuan,
      MaCanBo: userInfo.kthcMaCanBo,
      Nam: userInfo.kthcNam,
      Sgctgs: 0,
      Nlctgs: userInfo.kthcNlb || '',
      Ktctgs: userInfo.kthcPtkt || '',
      Idvunglv: userInfo.kthcIdvunglv || 68,
      Dcctgs: 'Có',
      Shctgs: '123',
      Plctgs: 'Dự toán'
    };
    
    // Merge với dữ liệu được cung cấp
    const finalCTGSData = { ...defaultCTGSData, ...ctgsData };
    
    console.log('📦 Dữ liệu tạo CTGS:', JSON.stringify(finalCTGSData, null, 2));
    
    // Tạo payload cho API - không encode dữ liệu tiếng Việt
    const payload = {
      values: JSON.stringify(finalCTGSData)
    };
    
    const result = await guiYeuCauPost(KTHC_ENDPOINTS.taoCTGS, payload, userInfo.token_httc);
    
    console.log('📊 Kết quả tạo CTGS:', JSON.stringify(result, null, 2));
    
    ghiLogHieuNangApi(startTime, 'Tạo CTGS mới', true);
    
    return {
      success: true,
      data: {
        idctgs: result.Idctgs,
        message: 'Tạo CTGS thành công'
      }
    };
    
  } catch (error) {
    ghiLogHieuNangApi(startTime, 'Tạo CTGS mới', false);
    throw new Error(dinhDangThongBaoLoi(error, 'Tạo CTGS mới'));
  }
}

module.exports = {
  layDanhsachCTGS,
  layIDCTGSMax,
  taoCTGSMoi
};
