const { guiYeuCauGet, guiYeuCauPost, guiYeuCauPostJson, capNhatChungTuField, ghiLogHieuNangApi, dinhDangThongBaoLoi } = require('../../utils/apiHelper');
const { KTHC_ENDPOINTS } = require('../../config/kthc');
const { dinhDangPhanHoiBaoHiem, dinhDangPhanHoiLoiApi, dinhDangPhanHoiChonCTGS, dinhDangPhanHoiKhongCoCTGS } = require('../../utils/responseHelper');
const { layDanhsachCTGS } = require('../ctgs/ctgsService');

// Get insurance information
async function layThongtinBaohiem(userInfo) {
  const startTime = Date.now();
  
  try {
    console.log('📋 Bước 1: Lấy thông tin bảo hiểm...');
    
    const params = {
      MaCoQuan: userInfo.kthcMaCoQuan,
      MaCanBo: userInfo.kthcMaCanBo,
      Msch: userInfo.kthcMsch || '622',
      Mslk: userInfo.kthcMslk || '070.073'
    };
    
    const getBaohiemResult = await guiYeuCauGet('/SubTaoBH2Get/GetBH', params, userInfo.token_httc);
    
    console.log('📊 GetBaohiem Result:', JSON.stringify(getBaohiemResult, null, 2));
    
    if (!getBaohiemResult.data || getBaohiemResult.data.length === 0) {
      throw new Error('Không tìm thấy dữ liệu bảo hiểm');
    }
    
    const baohiemData = getBaohiemResult.data[0];
    const idnhom = baohiemData.Idnhom;
    console.log('🔑 Idnhom từ GetBaohiem:', idnhom);
    
    ghiLogHieuNangApi(startTime, 'Get Baohiem Info', true);
    
    return {
      success: true,
      data: {
        idnhom: idnhom,
        baohiemData: baohiemData
      }
    };
    
  } catch (error) {
    ghiLogHieuNangApi(startTime, 'Get Baohiem Info', false);
    throw new Error(dinhDangThongBaoLoi(error, 'Lấy thông tin bảo hiểm'));
  }
}

// Create insurance with CTGS selection
async function taoBaohiem(userInfo, sessionId) {
  const startTime = Date.now();
  
  try {
    console.log('🎯 === BẮT ĐẦU XỬ LÝ "TẠO BẢO HIỂM THÁNG" ===');
    
    // Bước 1: Lấy thông tin bảo hiểm
    const baohiemInfo = await layThongtinBaohiem(userInfo);
    if (!baohiemInfo.success) {
      throw new Error(baohiemInfo.error);
    }
    
    const idnhom = baohiemInfo.data.idnhom;
    userInfo.idnhom = idnhom; // Thêm idnhom vào userInfo
    
    // Bước 2: Lấy danh sách CTGS
    const ctgsResult = await layDanhsachCTGS(userInfo);
    if (!ctgsResult.success) {
      throw new Error(ctgsResult.error);
    }
    
    // Kiểm tra response type từ layDanhsachCTGS
    if (ctgsResult.data && ctgsResult.data.type === 'ctgs_create_form') {
      console.log('📋 Chưa có CTGS, hiển thị form tạo CTGS mới');
      return {
        success: true,
        message: 'Chưa có CTGS, vui lòng tạo CTGS mới trước khi tạo bảo hiểm',
        data: ctgsResult.data // Trả về trực tiếp data từ ctgsResult
      };
    }
    
    // Nếu có CTGS list, xử lý bình thường
    const { ctgsList = [], totalCount = 0, accountingDetails = null } = ctgsResult.data || {};
    
    // Lưu thông tin vào session để user có thể chọn sau
    console.log('💾 Lưu CTGS selection vào session:', {
      sessionId: sessionId
    });
    
    // Trả về danh sách CTGS cho user chọn
    const response = dinhDangPhanHoiChonCTGS(
      ctgsList || [], 
      totalCount || 0, 
      accountingDetails || null, 
      {
        user: userInfo.user,
        maCoQuan: userInfo.kthcMaCoQuan,
        maCanBo: userInfo.kthcMaCanBo,
        nam: userInfo.kthcNam
      }
    );
    
    ghiLogHieuNangApi(startTime, 'Create Insurance with CTGS Selection', true);
    
    return response;
    
  } catch (error) {
    ghiLogHieuNangApi(startTime, 'Create Insurance with CTGS Selection', false);
    
    if (error.message.includes('Không tìm thấy CTGS nào')) {
      return dinhDangPhanHoiKhongCoCTGS(userInfo);
    }
    
    return dinhDangPhanHoiLoiApi(error, userInfo);
  }
}

// Create insurance with selected CTGS
async function taoBaohiemvoiCTGSDachon(userInfo, ctgsIndex, sessionId) {
  const startTime = Date.now();
  
  try {
    console.log('🎯 === TẠO BẢO HIỂM VỚI CTGS ĐÃ CHỌN ===');
    console.log('📋 CTGS Index:', ctgsIndex);
    
    // Lấy thông tin bảo hiểm trước
    const baohiemInfo = await layThongtinBaohiem(userInfo);
    if (!baohiemInfo.success) {
      throw new Error(baohiemInfo.error);
    }
    
    const idnhom = baohiemInfo.data.idnhom;
    
    // Lấy danh sách CTGS để tìm CTGS được chọn
    const ctgsResult = await layDanhsachCTGS(userInfo);
    if (!ctgsResult.success) {
      throw new Error(ctgsResult.error);
    }
    
    const { ctgsList = [] } = ctgsResult.data || {};
    
    // Tìm CTGS theo index
    const selectedCTGS = ctgsList.find(ctgs => ctgs.index === parseInt(ctgsIndex));
    if (!selectedCTGS) {
      throw new Error(`Không tìm thấy CTGS với index: ${ctgsIndex}`);
    }
    
    console.log('🎯 CTGS được chọn:', selectedCTGS);
    
    // Tạo bảo hiểm với CTGS được chọn - chỉ gửi tham số cần thiết
    const payload = {
      Idnhom: idnhom,
      Idctgs: selectedCTGS.id,
      Nam: userInfo.kthcNam,
      Checktb: userInfo.kthcChecktb || 0
    };
    
    console.log('🚀 Đang gọi API tạo bảo hiểm...');
    console.log('📦 Payload:', JSON.stringify(payload, null, 2));
    console.log('🔗 Endpoint:', '/SubTaoBH2/SubTaoBH2_Tao');
    console.log('🔑 Token:', userInfo.token_httc ? 'Có token' : 'Không có token');
    
    const result = await guiYeuCauPostJson('/SubTaoBH2/SubTaoBH2_Tao', payload, userInfo.token_httc);
    
    console.log('📊 API Result:', JSON.stringify(result, null, 2));
    
    // Kiểm tra kết quả API dựa vào message thay vì code
    if (result.message && result.message.includes('thành công')) {
      console.log('✅ TẠO BẢO HIỂM THÀNH CÔNG!');
      console.log('📝 Message:', result.message);
      
      // Cập nhật nội dung chứng từ sau khi tạo bảo hiểm thành công
      const currentTime = new Date().toLocaleString('vi-VN');
      const ndctValue = `AI-Chuyển bảo hiểm tháng ${userInfo.kthcThang}/${userInfo.kthcNam} lúc ${currentTime} ${selectedCTGS.soHieu || ''}`;
      
      console.log('📝 Đang cập nhật nội dung chứng từ...');
      console.log('📋 Ndct Value:', ndctValue);
      console.log('🔑 Idnhom được sử dụng cho PUT:', idnhom);
      console.log('🔑 Idnhom type:', typeof idnhom);
      console.log('🔑 Idnhom từ GetBaohiem:', baohiemInfo.data.idnhom);
      console.log('🔑 Idnhom từ API result:', result.code || result.idnhom);
      
      // Kiểm tra xem có nên sử dụng result.code thay vì idnhom không
      const putKey = result.code || idnhom;
      console.log('🔑 Sử dụng PUT key:', putKey);
      console.log('🔑 PUT key type:', typeof putKey);
      
      const updateResult = await capNhatChungTuField(
        '/ClassSubTaoBhnhoms/Put',
        putKey,
        'Ndct',
        ndctValue,
        userInfo.token_httc
      );
      
      console.log('✅ Cập nhật nội dung chứng từ thành công:', JSON.stringify(updateResult, null, 2));
      
      // Cập nhật ngày tháng ghi sổ với thời gian hiện tại
      const thoiGianHienTai = new Date().toISOString();
      console.log('📅 Đang cập nhật ngày tháng ghi sổ với thời gian hiện tại...');
      console.log('📋 Thời gian hiện tại cho Ntgs:', thoiGianHienTai);
      
      const ketQuaCapNhatNtgs = await capNhatChungTuField(
        '/ClassSubTaoBhnhoms/Put',
        putKey,
        'Ntgs',
        thoiGianHienTai,
        userInfo.token_httc
      );
      
      console.log('✅ Cập nhật ngày tháng ghi sổ thành công:', JSON.stringify(ketQuaCapNhatNtgs, null, 2));
      
      // Cập nhật ngày tháng chứng từ với thời gian hiện tại
      console.log('📅 Đang cập nhật ngày tháng chứng từ với thời gian hiện tại...');
      console.log('📋 Thời gian hiện tại cho Ntct:', thoiGianHienTai);
      
      const ketQuaCapNhatNtct = await capNhatChungTuField(
        '/ClassSubTaoBhnhoms/Put',
        putKey,
        'Ntct',
        thoiGianHienTai,
        userInfo.token_httc
      );
      
      console.log('✅ Cập nhật ngày tháng chứng từ thành công:', JSON.stringify(ketQuaCapNhatNtct, null, 2));
      
      console.log('🎉 HOÀN THÀNH TẤT CẢ CÁC BƯỚC CẬP NHẬT CHỨNG TỪ!');
      console.log('✅ Tất cả 3 lệnh PUT đã thành công:');
      console.log('   1. ✅ Cập nhật nội dung chứng từ (Ndct)');
      console.log('   2. ✅ Cập nhật ngày tháng ghi sổ (Ntgs)');
      console.log('   3. ✅ Cập nhật ngày tháng chứng từ (Ntct)');
      console.log('📋 Lưu ý: Response rỗng là bình thường với API PUT này');
    } else {
      console.log('❌ TẠO BẢO HIỂM THẤT BẠI!');
      console.log('❌ Code:', result.code);
      console.log('❌ Message:', result.message);
    }
    
    ghiLogHieuNangApi(startTime, 'Create Insurance with Selected CTGS', true);
    
         // Trả về response thành công - tương tự như lương
     return dinhDangPhanHoiBaoHiem({
       ctgsId: selectedCTGS.id,
       apiResult: result,
       month: userInfo.kthcThang,
       year: userInfo.kthcNam,
       processingTime: Date.now() - startTime,
       rawData: result
     });
    
  } catch (error) {
    ghiLogHieuNangApi(startTime, 'Create Insurance with Selected CTGS', false);
    return dinhDangPhanHoiLoiApi(error, userInfo);
  }
}

module.exports = {
  layThongtinBaohiem,
  taoBaohiem,
  taoBaohiemvoiCTGSDachon
};
