const { guiYeuCauGet, guiYeuCauPost, guiYeuCauPostJson, capNhatChungTuField, ghiLogHieuNangApi, dinhDangThongBaoLoi } = require('../../utils/apiHelper');
const { KTHC_ENDPOINTS } = require('../../config/kthc');
const { layDanhsachCTGS } = require('../ctgs/ctgsService');
const { dinhDangPhanHoiChonCTGS, dinhDangPhanHoiLuong, dinhDangPhanHoiLoiApi, dinhDangPhanHoiKhongCoCTGS } = require('../../utils/responseHelper');

// Get salary information
async function layThongtinLuong(userInfo) {
  const startTime = Date.now();
  
  try {
    console.log('📋 Bước 1: Lấy thông tin lương...');
    
    const params = {
      MaCoQuan: userInfo.kthcMaCoQuan,
      MaCanBo: userInfo.kthcMaCanBo
    };
    
    const getLuongResult = await guiYeuCauGet(KTHC_ENDPOINTS.getLuong, params, userInfo.token_httc);
    
    console.log('📊 GetLuong Result:', JSON.stringify(getLuongResult, null, 2));
    
    if (!getLuongResult.data || getLuongResult.data.length === 0) {
      throw new Error('Không tìm thấy dữ liệu lương');
    }
    
    const luongData = getLuongResult.data[0];
    const idnhom = luongData.Idnhom;
    console.log('🔑 Idnhom từ GetLuong:', idnhom);
    
    ghiLogHieuNangApi(startTime, 'Get Luong Info', true);
    
    return {
      success: true,
      data: {
        idnhom: idnhom,
        luongData: luongData
      }
    };
    
  } catch (error) {
    ghiLogHieuNangApi(startTime, 'Get Luong Info', false);
    throw new Error(dinhDangThongBaoLoi(error, 'Lấy thông tin lương'));
  }
}

// Create salary with CTGS selection
async function taoLuongvoiCTGS(userInfo, sessionId) {
  const startTime = Date.now();
  
  try {
    console.log('🎯 === BẮT ĐẦU XỬ LÝ "TẠO LƯƠNG THÁNG" ===');
    
    // Bước 1: Lấy thông tin lương
    const luongInfo = await layThongtinLuong(userInfo);
    if (!luongInfo.success) {
      throw new Error(luongInfo.error);
    }
    
    const idnhom = luongInfo.data.idnhom;
    userInfo.idnhom = idnhom; // Thêm idnhom vào userInfo
    
    // Bước 2: Lấy danh sách CTGS
    const ctgsResult = await layDanhsachCTGS(userInfo);
    if (!ctgsResult.success) {
      throw new Error(ctgsResult.error);
    }
    
    // Kiểm tra response type từ layDanhsachCTGS
    if (ctgsResult.data && ctgsResult.data.type === 'ctgs_create_form') {
      console.log('📋 Chưa có CTGS, hiển thị form tạo CTGS mới');
      return {
        success: true,
        message: 'Chưa có CTGS, vui lòng tạo CTGS mới trước khi tạo lương',
        data: ctgsResult.data // Trả về trực tiếp data từ ctgsResult
      };
    }
    
    // Nếu có CTGS list, xử lý bình thường
    const { ctgsList = [], totalCount = 0, accountingDetails = null } = ctgsResult.data || {};
    
    // Lưu thông tin vào session để user có thể chọn sau
    console.log('💾 Lưu CTGS selection vào session:', {
      sessionId: sessionId
    });
    
    // Trả về danh sách CTGS cho user chọn
            const response = dinhDangPhanHoiChonCTGS(
      ctgsList || [], 
      totalCount || 0, 
      accountingDetails || null, 
      {
        user: userInfo.user,
        maCoQuan: userInfo.kthcMaCoQuan,
        maCanBo: userInfo.kthcMaCanBo,
        nam: userInfo.kthcNam // Sử dụng năm từ userInfo thay vì hardcode
      }
    );
    
    ghiLogHieuNangApi(startTime, 'Create Salary with CTGS Selection', true);
    
    return response;
    
  } catch (error) {
    ghiLogHieuNangApi(startTime, 'Create Salary with CTGS Selection', false);
    
    if (error.message.includes('Không tìm thấy CTGS nào')) {
      return dinhDangPhanHoiKhongCoCTGS(userInfo);
    }
    
    return dinhDangPhanHoiLoiApi(error, userInfo);
  }
}

// Create salary with selected CTGS
async function taoLuongvoiCTGSDachon(userInfo, ctgsIndex, sessionId) {
  const startTime = Date.now();
  
  try {
    console.log('🎯 === TẠO LƯƠNG VỚI CTGS ĐÃ CHỌN ===');
    console.log('📋 CTGS Index:', ctgsIndex);
    
    // Lấy thông tin lương trước
    const luongInfo = await layThongtinLuong(userInfo);
    if (!luongInfo.success) {
      throw new Error(luongInfo.error);
    }
    
    const idnhom = luongInfo.data.idnhom;
    
    // Lấy danh sách CTGS để tìm CTGS được chọn
    const ctgsResult = await layDanhsachCTGS(userInfo);
    if (!ctgsResult.success) {
      throw new Error(ctgsResult.error);
    }
    
    const { ctgsList = [] } = ctgsResult.data || {};
    
    // Tìm CTGS theo index
    const selectedCTGS = ctgsList.find(ctgs => ctgs.index === parseInt(ctgsIndex));
    if (!selectedCTGS) {
      throw new Error(`Không tìm thấy CTGS với index: ${ctgsIndex}`);
    }
    
    console.log('🎯 CTGS được chọn:', selectedCTGS);
    
    // Tạo lương với CTGS được chọn - chỉ gửi tham số cần thiết
    const payload = {
      Idnhom: idnhom,
      Idctgs: selectedCTGS.id, // Không cần chuyển thành string
      Nam: userInfo.kthcNam,
      Checktb: userInfo.kthcChecktb || 0
    };
    
    console.log('🚀 Đang gọi API tạo lương...');
    console.log('📦 Payload:', JSON.stringify(payload, null, 2));
    console.log('🔗 Endpoint:', KTHC_ENDPOINTS.taoLuong);
    console.log('🔑 Token:', userInfo.token_httc ? 'Có token' : 'Không có token');
    console.log('📋 UserInfo:', {
      user: userInfo.user,
      kthcMaCoQuan: userInfo.kthcMaCoQuan,
      kthcMaCanBo: userInfo.kthcMaCanBo,
      kthcNam: userInfo.kthcNam,
      kthcThang: userInfo.kthcThang,
      kthcChecktb: userInfo.kthcChecktb,
      kthcIdvunglv: userInfo.kthcIdvunglv,
      kthcplgd: userInfo.kthcplgd
    });
    
    const result = await guiYeuCauPostJson(KTHC_ENDPOINTS.taoLuong, payload, userInfo.token_httc);
    
    console.log('📊 API Result:', JSON.stringify(result, null, 2));
    
         // Kiểm tra kết quả API dựa vào message thay vì code
     if (result.message && result.message.includes('thành công')) {
       console.log('✅ TẠO LƯƠNG THÀNH CÔNG!');
       console.log('📝 Message:', result.message);
       
       // Cập nhật nội dung chứng từ sau khi tạo lương thành công
       const currentTime = new Date().toLocaleString('vi-VN');
       const ndctValue = `AI-Chuyển lương tháng ${userInfo.kthcThang}/${userInfo.kthcNam} lúc ${currentTime} ${selectedCTGS.soHieu || ''}`;
       
       console.log('📝 Đang cập nhật nội dung chứng từ...');
       console.log('📋 Ndct Value:', ndctValue);
       
       const updateResult = await capNhatChungTuField(
         '/ClassSubTaoBhnhoms/Put',
         idnhom,
         'Ndct',
         ndctValue,
         userInfo.token_httc
       );
       
       console.log('✅ Cập nhật nội dung chứng từ thành công:', JSON.stringify(updateResult, null, 2));
       
               // Cập nhật ngày tháng ghi sổ với thời gian hiện tại
        const thoiGianHienTai = new Date().toISOString();
        console.log('📅 Đang cập nhật ngày tháng ghi sổ với thời gian hiện tại...');
        console.log('📋 Thời gian hiện tại cho Ntgs:', thoiGianHienTai);
        
        const ketQuaCapNhatNtgs = await capNhatChungTuField(
          '/ClassSubTaoBhnhoms/Put',
          idnhom,
          'Ntgs',
          thoiGianHienTai,
          userInfo.token_httc
        );
        
        console.log('✅ Cập nhật ngày tháng ghi sổ thành công:', JSON.stringify(ketQuaCapNhatNtgs, null, 2));
        
        // Cập nhật ngày tháng chứng từ với thời gian hiện tại
        console.log('📅 Đang cập nhật ngày tháng chứng từ với thời gian hiện tại...');
        console.log('📋 Thời gian hiện tại cho Ntct:', thoiGianHienTai);
        
        const ketQuaCapNhatNtct = await capNhatChungTuField(
          '/ClassSubTaoBhnhoms/Put',
          idnhom,
          'Ntct',
          thoiGianHienTai,
          userInfo.token_httc
        );
        
        console.log('✅ Cập nhật ngày tháng chứng từ thành công:', JSON.stringify(ketQuaCapNhatNtct, null, 2));
       
               console.log('🎉 HOÀN THÀNH TẤT CẢ CÁC BƯỚC CẬP NHẬT CHỨNG TỪ!');
        console.log('✅ Tất cả 3 lệnh PUT đã thành công:');
        console.log('   1. ✅ Cập nhật nội dung chứng từ (Ndct)');
        console.log('   2. ✅ Cập nhật ngày tháng ghi sổ (Ntgs)');
        console.log('   3. ✅ Cập nhật ngày tháng chứng từ (Ntct)');
        console.log('📋 Lưu ý: Response rỗng là bình thường với API PUT này');
    } else {
      console.log('❌ TẠO LƯƠNG THẤT BẠI!');
      console.log('❌ Code:', result.code);
      console.log('❌ Message:', result.message);
    }
    
    ghiLogHieuNangApi(startTime, 'Create Salary with Selected CTGS', true);
    
    // Trả về response thành công
    return dinhDangPhanHoiLuong({
      ctgsId: selectedCTGS.id,
      apiResult: result,
      month: userInfo.kthcThang,
      year: userInfo.kthcNam,
      totalEmployees: result.totalEmployees || 'Đang cập nhật',
      totalSalary: result.totalSalary || 'Đang tính toán',
      averageSalary: result.averageSalary || 'Đang tính toán',
      rawData: result
    });
    
  } catch (error) {
    ghiLogHieuNangApi(startTime, 'Create Salary with Selected CTGS', false);
    return dinhDangPhanHoiLoiApi(error, userInfo);
  }
}

module.exports = {
  layThongtinLuong,
  taoLuongvoiCTGS,
  taoLuongvoiCTGSDachon
};
