// KTHC API Configuration - Dynamic baseUrl
const KTHC_CONFIG = {
  baseUrl: null, // Sẽ được set động dựa trên domain
  timeout: 30000, // 30 seconds
  userAgent: 'ChatBot-GPT/1.0'
};

// Function to set KTHC baseUrl directly
function setKthcBaseUrl(apiServer) {
  try {
    KTHC_CONFIG.baseUrl = apiServer;
    console.log('🔗 KTHC API Server đã được set:', {
      baseUrl: KTHC_CONFIG.baseUrl
    });
    return KTHC_CONFIG.baseUrl;
  } catch (error) {
    console.error('❌ Lỗi khi set KTHC baseUrl:', error.message);
    // Fallback to default
    KTHC_CONFIG.baseUrl = process.env.KTHC_BASE_URL || 'https://kthcdemoapi.dtsoft.vn/api';
    return KTHC_CONFIG.baseUrl;
  }
}

// Function to get current KTHC baseUrl
function getKthcBaseUrl() {
  return KTHC_CONFIG.baseUrl;
}

// API Endpoints
const KTHC_ENDPOINTS = {
  // Lương
  getLuong: '/SubTaoBH/GetLuong',
  taoLuong: '/SubTaoBH/kthc_Nhapctkt_TaoLuong',
  
  // Bảo hiểm
  taoBaoHiem: '/ClassSubTaoBhnhoms/Put',
  
  // Công đoàn
  taoCongDoan: '/SubTaoBH/kthc_Nhapctkt_TaoCongDoan',
  
  // CTGS
  getCTGS: '/Ctgs/Get',
  getIDCTGSMax: '/Ctgs/GetIDCTGSMax',
  taoCTGS: '/Ctgs/Post',
  
  // Chi tiết hạch toán
  getChiTietHachToan: '/ClassSubTaoBhs/Get'
};

// Không có default parameters - yêu cầu user cung cấp đầy đủ thông tin

// Build API URL
function taoApiUrl(endpoint, params = {}) {
  const url = new URL(KTHC_CONFIG.baseUrl + endpoint);
  
  // Add query parameters
  Object.keys(params).forEach(key => {
    if (params[key] !== undefined && params[key] !== null) {
      url.searchParams.append(key, params[key]);
    }
  });
  
  return url.toString();
}

// Build headers for API request
function taoHeaders(token) {
  // Use token as is, but ensure it's a valid string
  let authToken = token;
  if (token && typeof token === 'string') {
    // Only add Bearer prefix if not already present
    authToken = token.startsWith('Bearer ') ? token : `Bearer ${token}`;
  }
  
  return {
    'accept': 'application/json',
    'Authorization': authToken,
    'User-Agent': KTHC_CONFIG.userAgent,
    'Content-Type': 'application/json'
  };
}

// Validate API parameters
function kiemtraApiParams(apiParams) {
  const required = ['token_httc', 'kthcMaCoQuan', 'kthcMaCanBo'];
  const missing = required.filter(param => !apiParams[param]);
  
  if (missing.length > 0) {
    throw new Error(`Thiếu tham số bắt buộc: ${missing.join(', ')}`);
  }
  
  return true;
}

// Extract user info from API params - yêu cầu đầy đủ thông tin
function layThongtinUser(apiParams) {
  // Kiểm tra các tham số bắt buộc (chỉ những tham số thực sự cần thiết)
  const requiredParams = ['token_httc', 'kthcMaCoQuan', 'kthcMaCanBo', 'kthcNam'];
  const missingParams = requiredParams.filter(param => !apiParams[param]);
  
  if (missingParams.length > 0) {
    throw new Error(`Thiếu tham số bắt buộc: ${missingParams.join(', ')}. Vui lòng cung cấp đầy đủ thông tin tài khoản.`);
  }
  
  return {
    user: apiParams.user || 'User',
    token_httc: apiParams.token_httc,
    kthcplgd: apiParams.kthcplgd || 'KH-CB',
    kthcMaCoQuan: parseInt(apiParams.kthcMaCoQuan),
    kthcMaCanBo: parseInt(apiParams.kthcMaCanBo),
    kthcIdvunglv: parseInt(apiParams.kthcIdvunglv) || 1,
    kthcNam: parseInt(apiParams.kthcNam),
    kthcThang: parseInt(apiParams.kthcThang) || new Date().getMonth() + 1, // Mặc định tháng hiện tại
    kthcChecktb: parseInt(apiParams.kthcChecktb) || 0, // Mặc định là 0
    kthcIdctgs: apiParams.kthcIdctgs ? parseInt(apiParams.kthcIdctgs) : undefined, // Optional parameter
    kthcNlb: apiParams.kthcNlb || '', // Lập biểu
    kthcPtkt: apiParams.kthcPtkt || '' // Kế toán
  };
}

module.exports = {
  KTHC_CONFIG,
  KTHC_ENDPOINTS,
  taoApiUrl,
  taoHeaders,
  kiemtraApiParams,
  layThongtinUser,
  setKthcBaseUrl,
  getKthcBaseUrl
};
