const OpenAI = require('openai');

// OpenAI Configuration
const CHATBOT_CONFIG = {
  assistantId: process.env.ASSISTANT_ID || 'asst_0nXp6vSvvGMUjNUjcX3NVUGa',
  maxCompletionTokens: 200,
  vectorStoreId: process.env.VECTOR_STORE_ID || 'vs_68a57ca699c88191a21350a70657848d'
};

// OpenAI client
const openai = new OpenAI({
  apiKey: process.env.OPENAI_API_KEY || 'your-api-key-here'
});

// Check if OpenAI is configured
function kiemtraOpenAIDacauhinh() {
  return process.env.OPENAI_API_KEY && process.env.OPENAI_API_KEY !== 'your-api-key-here';
}

// Get OpenAI client
function layOpenAIClient() {
  return openai;
}

// Get chatbot config
function layChatbotConfig() {
  return CHATBOT_CONFIG;
}

module.exports = {
  openai,
  CHATBOT_CONFIG,
  kiemtraOpenAIDacauhinh,
  layOpenAIClient,
  layChatbotConfig
};
