// Server Configuration
const SERVER_CONFIG = {
    // Base URL - có thể thay đổi theo environment
    BASE_URL: process.env.BASE_URL || 'http://localhost:3000',
    
    // API Endpoints
    ENDPOINTS: {
        CHAT: '/api/chat',
        CTGS_CREATE: '/api/ctgs/create',
        CTGS_LIST: '/api/ctgs/list',
        LUONG: '/api/luong',
        BAOHIEM: '/api/bao-hiem',
        CONGDOAN: '/api/cong-doan',
        HEALTH: '/api/health'
    },
    
    // Port configuration
    PORT: process.env.PORT || 3000,
    
    // Environment
    NODE_ENV: process.env.NODE_ENV || 'development',
    
    // CORS settings
    CORS_ORIGIN: process.env.CORS_ORIGIN || '*',
    
    // Session settings
    SESSION_SECRET: process.env.SESSION_SECRET || 'your-secret-key',
    SESSION_TIMEOUT: process.env.SESSION_TIMEOUT || 3600000, // 1 hour
    
    // API settings
    API_TIMEOUT: process.env.API_TIMEOUT || 30000, // 30 seconds
    MAX_FILE_SIZE: process.env.MAX_FILE_SIZE || '10mb'
};

// Helper functions
const getApiUrl = (endpoint) => {
    return SERVER_CONFIG.BASE_URL + (SERVER_CONFIG.ENDPOINTS[endpoint] || endpoint);
};

const getFullUrl = (path) => {
    return SERVER_CONFIG.BASE_URL + path;
};

// Export configuration
module.exports = {
    SERVER_CONFIG,
    getApiUrl,
    getFullUrl
};

