# 🗄️ Cấu hình Database cho cPanel Deployment

## 📋 **Bước 1: Tạo Database trong cPanel**

### **1.1 Đăng nhập cPanel**
- Đăng nhập vào cPanel của hosting
- Tìm phần **"Databases"** hoặc **"MySQL Databases"**

### **1.2 Tạo Database**
1. **Tạo Database mới:**
   - Database Name: `yourusername_chatbot_gpt`
   - Prefix thường là: `yourusername_`
   - Ví dụ: `muvietplus_chatbot_gpt`

2. **Tạo Database User:**
   - Username: `yourusername_chatbot_user`
   - Password: `your_secure_password_here`
   - Ví dụ: `muvietplus_chatbot_user`

3. **Gán quyền cho User:**
   - Chọn user vừa tạo
   - Gán quyền **ALL PRIVILEGES** cho database

## 📋 **Bước 2: Import Database Schema**

### **2.1 Sử dụng phpMyAdmin**
1. Vào **phpMyAdmin** trong cPanel
2. Chọn database vừa tạo
3. Chọn tab **"SQL"**
4. Copy và paste nội dung từ file `database-setup.sql`
5. Click **"Go"** để thực thi

### **2.2 Hoặc sử dụng HeidiSQL để Export/Import**
1. **Export từ HeidiSQL (Local):**
   ```sql
   -- Export database structure và data
   mysqldump -u root -p chatbot_gpt > chatbot_gpt_backup.sql
   ```

2. **Import vào cPanel:**
   - Upload file `.sql` lên cPanel
   - Import qua phpMyAdmin

## 📋 **Bước 3: Cấu hình Environment Variables**

### **3.1 Tạo file .env trong cPanel**
```env
# Database Configuration cho cPanel
DB_HOST=localhost
DB_PORT=3306
DB_USER=yourusername_chatbot_user
DB_PASSWORD=your_secure_password_here
DB_NAME=yourusername_chatbot_gpt

# OpenAI Configuration
OPENAI_API_KEY=your_openai_api_key_here

# Server Configuration
PORT=3000
NODE_ENV=production

# KTHC API Configuration
KTHC_BASE_URL=https://kthcdemoapi.dtsoft.vn/api
```

### **3.2 Hoặc cấu hình qua cPanel Environment Variables**
- Vào **"Environment Variables"** trong cPanel
- Thêm từng biến môi trường

## 📋 **Bước 4: Cấu hình Application**

### **4.1 Upload code lên cPanel**
1. Upload toàn bộ project lên thư mục `public_html/chatbot-gpt/`
2. Chạy `npm install` trong terminal cPanel

### **4.2 Khởi tạo Database**
```bash
# Trong terminal cPanel
cd public_html/chatbot-gpt
npm run init-db
```

### **4.3 Chạy ứng dụng**
```bash
# Sử dụng PM2 hoặc Node.js
npm start
```

## 🔧 **Cấu hình cPanel cụ thể:**

### **MySQL Database Settings:**
- **Host:** `localhost` (thường là localhost)
- **Port:** `3306` (mặc định)
- **Database Name:** `yourusername_chatbot_gpt`
- **Username:** `yourusername_chatbot_user`
- **Password:** `your_secure_password`

### **File Permissions:**
```bash
# Set permissions cho Node.js app
chmod 755 public_html/chatbot-gpt
chmod 644 public_html/chatbot-gpt/.env
```

### **Cron Jobs (tùy chọn):**
```bash
# Cập nhật thống kê hàng ngày
0 2 * * * cd /home/yourusername/public_html/chatbot-gpt && node -e "require('./services/databaseService').StatisticsService.updateDailyStats()"
```

## 🚀 **Deployment Checklist:**

- [ ] Tạo database trong cPanel
- [ ] Tạo database user và gán quyền
- [ ] Import database schema
- [ ] Upload code lên cPanel
- [ ] Cấu hình environment variables
- [ ] Chạy `npm install`
- [ ] Chạy `npm run init-db`
- [ ] Test kết nối database
- [ ] Chạy ứng dụng
- [ ] Test API endpoints

## 📊 **Test Database Connection:**

```bash
# Test kết nối
curl http://yourdomain.com/chatbot-gpt/api/statistics/overview

# Test chat
curl -X POST http://yourdomain.com/chatbot-gpt/api/chat \
  -H "Content-Type: application/json" \
  -d '{"sessionId":"test","message":"KTHC Online là gì?"}'
```

## 🔒 **Security Notes:**

1. **Password mạnh:** Sử dụng password phức tạp cho database
2. **Environment Variables:** Không commit `.env` file
3. **Database Prefix:** Luôn sử dụng prefix của cPanel
4. **Backup:** Backup database thường xuyên
5. **SSL:** Sử dụng HTTPS cho production

## 📞 **Support:**

Nếu gặp vấn đề:
1. Kiểm tra logs trong cPanel
2. Test kết nối database
3. Kiểm tra file permissions
4. Contact hosting support
