// Deployment Configuration for cPanel
// Sử dụng file này để cấu hình khi deploy lên server

const DEPLOY_CONFIG = {
    // ===== CẤU HÌNH SERVER =====
    SERVER: {
        // Thay đổi URL này khi deploy
        BASE_URL: 'https://yourdomain.com', // Thay bằng domain thực tế
        PORT: process.env.PORT || 3000,
        NODE_ENV: 'production'
    },
    
    // ===== CẤU HÌNH DATABASE =====
    DATABASE: {
        // File paths
        SESSIONS_FILE: './sessions.json',
        LOGS_DIR: './logs',
        BACKUP_DIR: './backups'
    },
    
    // ===== CẤU HÌNH API =====
    API: {
        TIMEOUT: 30000,
        MAX_FILE_SIZE: '10mb',
        CORS_ORIGIN: '*'
    },
    
    // ===== CẤU HÌNH SECURITY =====
    SECURITY: {
        SESSION_SECRET: process.env.SESSION_SECRET || 'your-production-secret-key',
        SESSION_TIMEOUT: 3600000, // 1 hour
        RATE_LIMIT: {
            windowMs: 15 * 60 * 1000, // 15 minutes
            max: 100 // limit each IP to 100 requests per windowMs
        }
    },
    
    // ===== CẤU HÌNH LOGGING =====
    LOGGING: {
        LEVEL: 'info',
        FILE: './logs/app.log',
        ERROR_FILE: './logs/error.log'
    }
};

// ===== HƯỚNG DẪN SỬ DỤNG =====

// 1. Thay đổi BASE_URL thành domain thực tế
// DEPLOY_CONFIG.SERVER.BASE_URL = 'https://yourdomain.com';

// 2. Cấu hình environment variables trong cPanel
// NODE_ENV=production
// PORT=3000
// SESSION_SECRET=your-secret-key
// BASE_URL=https://yourdomain.com

// 3. Cập nhật chatbot-widget.js để sử dụng cấu hình này
// window.SERVER_CONFIG = DEPLOY_CONFIG.SERVER;

module.exports = DEPLOY_CONFIG;

