module.exports = {
  apps: [{
    name: 'chatbot-gpt',
    script: 'server-new.js',
    instances: 1,
    autorestart: true,
    watch: false,
    max_memory_restart: '1G',
    env: {
      NODE_ENV: 'production',
      PORT: 3000
    },
    env_production: {
      NODE_ENV: 'production',
      PORT: 3000
    }
  }],

  deploy: {
    production: {
      user: 'node',
      host: 'localhost',
      ref: 'origin/master',
      repo: 'git@github.com:repo/chatbot-gpt.git',
      path: '/var/www/chatbot-gpt',
      'post-deploy': 'npm install && pm2 reload ecosystem.config.js --env production'
    }
  }
};
