require('dotenv').config();
const { sequelize, testConnection, syncDatabase } = require('./config/database');
const { ApiMappingService, QADatabaseService } = require('./services/databaseService');

async function initializeDatabase() {
  console.log('🚀 Khởi tạo database...');
  
  try {
    // Test kết nối
    console.log('📡 Kiểm tra kết nối database...');
    const isConnected = await testConnection();
    if (!isConnected) {
      console.log('❌ Không thể kết nối database');
      console.log('📋 Vui lòng kiểm tra:');
      console.log('   - MySQL server đang chạy');
      console.log('   - Thông tin kết nối trong .env');
      console.log('   - Database đã được tạo');
      return false;
    }

    // Sync database
    console.log('🔄 Đồng bộ database...');
    await syncDatabase();

    // Import API mappings
    console.log('📥 Import API mappings...');
    await ApiMappingService.importFromJson();

    // Import Q&A database
    console.log('📥 Import Q&A database...');
    await QADatabaseService.importFromJson();

    console.log('✅ Database đã được khởi tạo thành công!');
    console.log('📊 Các bảng đã được tạo:');
    console.log('   - api_mappings');
    console.log('   - qa_database');
    console.log('   - chat_sessions');
    console.log('   - chat_messages');
    console.log('   - chat_statistics');

    return true;
  } catch (error) {
    console.error('❌ Lỗi khởi tạo database:', error);
    return false;
  }
}

// Chạy script
if (require.main === module) {
  initializeDatabase().then((success) => {
    process.exit(success ? 0 : 1);
  });
}

module.exports = { initializeDatabase };
