@echo off
echo ========================================
echo    CHATBOT GPT - PM2 MANAGEMENT
echo ========================================
echo.

echo [INFO] PM2 Management for ChatBot GPT
echo.

echo [1] Start ChatBot GPT with PM2
echo [2] Stop ChatBot GPT
echo [3] Restart ChatBot GPT
echo [4] Show PM2 status
echo [5] Show PM2 logs
echo [6] Exit
echo.

set /p choice="Please select an option (1-6): "

if "%choice%"=="1" (
    echo [INFO] Starting ChatBot GPT with PM2...
    pm2 start ecosystem.config.js --env production
    echo [✓] ChatBot GPT started with PM2
    echo [INFO] You can now access: http://localhost:3000
    echo [INFO] For domain access, setup reverse proxy
) else if "%choice%"=="2" (
    echo [INFO] Stopping ChatBot GPT...
    pm2 stop chatbot-gpt
    echo [✓] ChatBot GPT stopped
) else if "%choice%"=="3" (
    echo [INFO] Restarting ChatBot GPT...
    pm2 restart chatbot-gpt
    echo [✓] ChatBot GPT restarted
) else if "%choice%"=="4" (
    echo [INFO] PM2 Status:
    pm2 status
) else if "%choice%"=="5" (
    echo [INFO] PM2 Logs:
    pm2 logs chatbot-gpt
) else if "%choice%"=="6" (
    echo [INFO] Exiting...
    exit /b 0
) else (
    echo [ERROR] Invalid option
)

echo.
pause
