# 🚀 Hướng Dẫn Deploy Lên Node.js cPanel

## 📋 Yêu Cầu Hệ Thống

- **Node.js**: Phiên bản 14.0.0 trở lên
- **npm**: Phiên bản 6.0.0 trở lên
- **cPanel**: Có hỗ trợ Node.js
- **Domain/Subdomain**: Để truy cập ứng dụng

## 📁 Cấu Trúc Files Cần Upload

```
rag/
├── package.json              # Cấu hình Node.js
├── server.js                 # Server Express.js
├── qa-manager.html           # Giao diện chính
├── qa-manager.js             # Logic xử lý
├── qa-demo.html              # Trang demo
├── qa-test.html              # Trang test
├── kthc-qa-database.json     # Database gốc
├── QA-MANAGER-README.md      # Tài liệu
└── DEPLOY-GUIDE.md           # Hướng dẫn này
```

## 🔧 Bước 1: Chuẩn Bị Files

### 1.1 Tạo thư mục backup
```bash
mkdir backups
```

### 1.2 Kiểm tra files
```bash
ls -la
# Đảm bảo có đầy đủ các files cần thiết
```

## 🌐 Bước 2: Upload Lên cPanel

### 2.1 Truy cập cPanel
1. Đăng nhập vào cPanel
2. Tìm phần **"Node.js"** hoặc **"Node.js Selector"**

### 2.2 Tạo Node.js App
1. Click **"Create Application"**
2. Điền thông tin:
   - **Node.js version**: 14.x hoặc cao hơn
   - **Application mode**: Production
   - **Application root**: `/home/username/rag` (hoặc thư mục bạn muốn)
   - **Application URL**: `yourdomain.com` hoặc `subdomain.yourdomain.com`
   - **Application startup file**: `server.js`
   - **Passenger port**: Để trống (tự động)

### 2.3 Upload Files
1. Sử dụng **File Manager** hoặc **FTP**
2. Upload tất cả files vào thư mục `/home/username/rag/`
3. Đảm bảo quyền truy cập:
   ```bash
   chmod 755 server.js
   chmod 644 *.html *.js *.json
   chmod 755 backups/
   ```

## 📦 Bước 3: Cài Đặt Dependencies

### 3.1 SSH vào server (nếu có)
```bash
ssh username@yourdomain.com
cd rag
npm install
```

### 3.2 Hoặc sử dụng cPanel Terminal
```bash
cd rag
npm install --production
```

### 3.3 Kiểm tra cài đặt
```bash
npm list
# Kiểm tra các packages đã cài đặt
```

## ⚙️ Bước 4: Cấu Hình Server

### 4.1 Tạo file .htaccess (nếu cần)
```apache
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^(.*)$ /server.js [QSA,L]
```

### 4.2 Cấu hình environment variables
Trong cPanel Node.js:
- **NODE_ENV**: `production`
- **PORT**: Để trống (tự động)

## 🚀 Bước 5: Khởi Động Ứng Dụng

### 5.1 Trong cPanel Node.js
1. Click **"Restart Application"**
2. Đợi vài giây để ứng dụng khởi động
3. Kiểm tra logs nếu có lỗi

### 5.2 Kiểm tra hoạt động
```bash
curl http://yourdomain.com/api/health
# Kết quả mong đợi: {"status":"OK","timestamp":"...","version":"1.0.0"}
```

## 🔍 Bước 6: Kiểm Tra và Test

### 6.1 Test các endpoints
- **Trang chính**: `http://yourdomain.com/`
- **Demo**: `http://yourdomain.com/demo`
- **Test**: `http://yourdomain.com/test`
- **API Health**: `http://yourdomain.com/api/health`
- **API Stats**: `http://yourdomain.com/api/stats`

### 6.2 Test chức năng
1. Mở trang chính
2. Thêm câu hỏi mới
3. Sửa/xóa câu hỏi
4. Export/Import dữ liệu
5. Tạo backup

## 🛠️ Bước 7: Cấu Hình Nâng Cao

### 7.1 SSL/HTTPS
1. Trong cPanel, tìm **"SSL/TLS"**
2. Cài đặt SSL certificate
3. Force HTTPS redirect

### 7.2 Domain/Subdomain
1. Tạo subdomain: `qa.yourdomain.com`
2. Point đến thư mục `/home/username/rag/`
3. Cấu hình DNS nếu cần

### 7.3 Backup tự động
```bash
# Tạo cron job để backup hàng ngày
0 2 * * * cd /home/username/rag && node -e "require('./server.js').backup()"
```

## 📊 Bước 8: Monitoring

### 8.1 Logs
- **Error logs**: `/home/username/rag/logs/error.log`
- **Access logs**: `/home/username/rag/logs/access.log`

### 8.2 Performance
- Monitor CPU/Memory usage
- Check disk space
- Monitor response time

## 🔧 Troubleshooting

### Lỗi thường gặp

#### 1. Port đã được sử dụng
```
Error: listen EADDRINUSE: address already in use :::3000
```
**Giải pháp**: Thay đổi port trong `server.js` hoặc kill process cũ

#### 2. Permission denied
```
Error: EACCES: permission denied
```
**Giải pháp**: 
```bash
chmod 755 server.js
chmod 644 *.json
```

#### 3. Module not found
```
Error: Cannot find module 'express'
```
**Giải pháp**: 
```bash
npm install
npm install --production
```

#### 4. Database không load được
```
Error: Lỗi khi tải dữ liệu!
```
**Giải pháp**: Kiểm tra file `kthc-qa-database.json` có tồn tại không

### Debug Mode
```bash
# Bật debug mode
NODE_ENV=development node server.js

# Xem logs chi tiết
tail -f logs/error.log
```

## 🔒 Bảo Mật

### 1. Environment Variables
```bash
# Tạo file .env
NODE_ENV=production
PORT=3000
SECRET_KEY=your_secret_key
```

### 2. Rate Limiting
```javascript
// Thêm vào server.js
const rateLimit = require('express-rate-limit');
app.use(rateLimit({
    windowMs: 15 * 60 * 1000, // 15 phút
    max: 100 // giới hạn 100 requests
}));
```

### 3. CORS Configuration
```javascript
// Cấu hình CORS chi tiết
app.use(cors({
    origin: ['https://yourdomain.com'],
    credentials: true
}));
```

## 📈 Performance Optimization

### 1. Compression
```bash
npm install compression
```
```javascript
const compression = require('compression');
app.use(compression());
```

### 2. Caching
```javascript
// Cache static files
app.use(express.static(path.join(__dirname), {
    maxAge: '1d',
    etag: true
}));
```

### 3. Database Optimization
- Sử dụng indexing cho tìm kiếm
- Implement pagination
- Cache frequently accessed data

## 🔄 Maintenance

### 1. Update ứng dụng
```bash
# Backup trước khi update
cp -r rag rag_backup_$(date +%Y%m%d)

# Upload files mới
# Restart application
```

### 2. Database backup
```bash
# Backup hàng ngày
cp kthc-qa-database.json backups/daily_$(date +%Y%m%d).json

# Cleanup old backups (giữ 30 ngày)
find backups/ -name "daily_*.json" -mtime +30 -delete
```

### 3. Log rotation
```bash
# Rotate logs hàng tuần
logrotate /etc/logrotate.d/qa-manager
```

## 📞 Hỗ Trợ

### Liên hệ khi gặp vấn đề
- **Email**: support@yourdomain.com
- **Documentation**: [Wiki](https://github.com/your-repo/wiki)
- **Issues**: [GitHub Issues](https://github.com/your-repo/issues)

### Thông tin server
- **Server**: yourdomain.com
- **Port**: 3000 (hoặc tự động)
- **Node.js Version**: 14.x+
- **Database**: JSON file
- **Backup Location**: `/home/username/rag/backups/`

---

**Phiên bản**: 1.0.0  
**Cập nhật**: 26/12/2024  
**Tác giả**: ChatBot GPT Assistant

