# 📚 Database Q&A KTHC Online

## 📋 Mô Tả (Description)

Database Q&A cho **KTHC Online** - Phần mềm Kế toán Hành chính Sự nghiệp Online, được tạo từ file hướng dẫn chính thức của Công ty TNHH Phát triển và Chuyển giao Phần mềm.

## 📊 Thống Kê (Statistics)

- **Tổng số câu hỏi**: 35 câu hỏi
- **Số danh mục**: 7 danh mục
- **Nguồn dữ liệu**: Hướng dẫn KTHC Online 26072025.docx
- **Ngày tạo**: 26/12/2024
- **Phiên bản**: 1.0

## 🗂️ Danh Mục Câu Hỏi (Question Categories)

### 1. 📖 **Tổng Quan (Overview)**
- KTHC Online là gì?
- Các chức năng chính của KTHC Online?

### 2. 🔐 **Đăng Nhập (Login)**
- Làm thế nào để đăng nhập KTHC Online?

### 3. ⚙️ **Cấu Hình (Configuration)**
- Cách cấu hình số liệu hệ thống?
- Cách khóa/mở sổ kế toán?
- Cách chuyển số dư năm cũ sang năm mới?
- Cách quản lý danh mục trong KTHC Online?
- Cách đặt chứng từ mặc định?
- Cách sử dụng API trong KTHC Online?
- Cách sử dụng vùng làm việc và vùng kết xuất?

### 4. 🛠️ **Tiện Ích (Utilities)**
- Cách tạo lương trong KTHC Online?
- Cách tạo bảo hiểm trong KTHC Online?
- Cách tạo kinh phí công đoàn?
- Cách tạo chuyển khoản?
- Cách tạo rút và chi tiền mặt?
- Cách tạo ủy nhiệm chi?
- Cách tạo thanh toán tạm ứng?
- Cách tạo giao dự toán?
- Cách sử dụng tiện ích nhập liệu?

### 5. 📋 **Quản Lý (Management)**
- Cách nhập chứng từ kế toán?
- Cách quản lý tài sản cố định?
- Cách đăng ký khấu hao TSCĐ?
- Cách nhập số dư đầu năm?
- Cách nhập số dư cam kết chi?
- Cách nhập BCTC năm trước?
- Các phân loại chứng từ trong KTHC Online?
- Cách quản lý nhân sự và tiền lương?
- Cách sử dụng các nút lệnh trong nhập chứng từ?

### 6. 🖨️ **In Chứng Từ (Document Printing)**
- Cách in chứng từ trong KTHC Online?
- Cách tạo và in phiếu thu?
- Cách tạo và in phiếu chi?
- Cách tạo giấy rút dự toán ngân sách?
- Cách tạo bảng kê chứng từ thanh toán?
- Cách tạo ủy nhiệm chi?
- Cách in sổ sách kế toán?

### 7. 📊 **Báo Cáo (Reports)**
- Các loại báo cáo trong KTHC Online?
- Cách tạo báo cáo quyết toán theo TT24?

## 🔍 Cách Sử Dụng (Usage)

### 📁 File Database
```json
rag/kthc-qa-database.json
```

### 🏗️ Cấu Trúc Dữ Liệu (Data Structure)
```json
{
  "question": "Câu hỏi",
  "answer": "Câu trả lời chi tiết",
  "category": "danh_mục",
  "keywords": ["từ_khóa_1", "từ_khóa_2"]
}
```

### 🔧 Tích Hợp Với ChatBot
Database này có thể được tích hợp với ChatBot GPT để:
- Trả lời câu hỏi về KTHC Online
- Hướng dẫn sử dụng phần mềm
- Giải đáp thắc mắc về chức năng
- Cung cấp thông tin chi tiết về quy trình

## 📝 Ghi Chú (Notes)

### ✅ Đã Bao Gồm (Included)
- Tất cả chức năng chính của KTHC Online
- Hướng dẫn chi tiết từng bước
- Các tiện ích nhập liệu tự động
- Quy trình in chứng từ và báo cáo
- Cấu hình hệ thống và danh mục

### 🔄 Có Thể Bổ Sung (Can Be Extended)
- Thêm câu hỏi về lỗi thường gặp
- Bổ sung hướng dẫn nâng cao
- Thêm ví dụ thực tế
- Cập nhật theo phiên bản mới

## 🔗 Liên Kết (Links)

- **File gốc**: `Hướng dẫn KTHC Online 26072025.docx`
- **Database JSON**: `rag/kthc-qa-database.json`
- **ChatBot Integration**: `public/chatbot-widget.js`

## 📞 Hỗ Trợ (Support)

Nếu cần bổ sung hoặc cập nhật database, vui lòng:
1. Thêm câu hỏi mới vào file JSON
2. Cập nhật metadata
3. Kiểm tra tính nhất quán của dữ liệu

---

**Tác giả**: ChatBot GPT Assistant  
**Ngày cập nhật**: 26/12/2024  
**Phiên bản**: 1.0
