# 📚 Hệ Thống Quản Lý Database Q&A KTHC

## 🎯 Mô Tả

Hệ thống quản lý câu hỏi và trả lời cho **KTHC Online** với giao diện web thân thiện, hỗ trợ đầy đủ các chức năng CRUD (Create, Read, Update, Delete).

## 📁 Cấu Trúc Files

```
rag/
├── qa-manager.html          # Giao diện chính
├── qa-manager.js            # Logic xử lý dữ liệu
├── kthc-qa-database.json    # Database gốc
├── qa-test.html             # Trang test tìm kiếm
├── qa-search.js             # Logic tìm kiếm
└── QA-MANAGER-README.md     # Hướng dẫn này
```

## 🚀 Cách Sử Dụng

### 1. Mở Giao Diện Quản Lý

```bash
# Mở file trong trình duyệt
open rag/qa-manager.html
```

Hoặc truy cập: `http://localhost:3000/rag/qa-manager.html`

### 2. Các Chức Năng Chính

#### 📖 **Xem Dữ Liệu**
- ✅ Hiển thị tất cả câu hỏi với thông tin chi tiết
- ✅ Thống kê tổng quan (số câu hỏi, danh mục, từ khóa)
- ✅ Lọc theo danh mục
- ✅ Tìm kiếm theo từ khóa

#### ➕ **Thêm Mới**
- ✅ Thêm câu hỏi mới với đầy đủ thông tin
- ✅ Quản lý từ khóa (thêm/xóa)
- ✅ Validate dữ liệu đầu vào
- ✅ Tự động tạo ID và timestamp

#### ✏️ **Sửa Đổi**
- ✅ Chỉnh sửa câu hỏi đã có
- ✅ Cập nhật từ khóa
- ✅ Lưu lịch sử thay đổi

#### 🗑️ **Xóa**
- ✅ Xóa câu hỏi với xác nhận
- ✅ Khôi phục từ backup

#### 📤 **Xuất/Nhập**
- ✅ Xuất dữ liệu ra file JSON
- ✅ Import dữ liệu từ file JSON
- ✅ Hỗ trợ merge dữ liệu

## 🎨 Giao Diện

### Header
- **Tiêu đề**: Quản Lý Database Q&A KTHC
- **Thống kê**: Tổng câu hỏi, số danh mục, số từ khóa

### Sidebar
- **Tìm kiếm**: Tìm kiếm theo từ khóa
- **Lọc danh mục**: Chọn danh mục cụ thể
- **Nút thao tác**: Thêm, sửa, xóa, xuất/nhập

### Content Area
- **Danh sách câu hỏi**: Hiển thị dạng card
- **Thông tin chi tiết**: Câu hỏi, câu trả lời, danh mục, từ khóa
- **Trạng thái chọn**: Highlight câu hỏi được chọn

## 📊 Cấu Trúc Dữ Liệu

### Format JSON
```json
{
  "kthc_qa_database": [
    {
      "id": "unique_id",
      "question": "Câu hỏi",
      "answer": "Câu trả lời chi tiết",
      "category": "danh_mục",
      "keywords": ["từ_khóa_1", "từ_khóa_2"],
      "created_at": "2024-12-26T10:00:00.000Z",
      "updated_at": "2024-12-26T10:00:00.000Z"
    }
  ],
  "metadata": {
    "last_updated": "2024-12-26T10:00:00.000Z",
    "total_questions": 35,
    "categories": ["tổng_quan", "đăng_nhập", "cấu_hình"],
    "total_keywords": 150
  }
}
```

### Danh Mục Hỗ Trợ
- `tổng_quan` - Tổng quan về KTHC
- `đăng_nhập` - Hướng dẫn đăng nhập
- `cấu_hình` - Cấu hình hệ thống
- `tiện_ích` - Các tiện ích nhập liệu
- `quản_lý` - Quản lý chứng từ, TSCĐ
- `in_chứng_từ` - In chứng từ và báo cáo
- `báo_cáo` - Các loại báo cáo

## 🔧 Tính Năng Nâng Cao

### Tìm Kiếm Thông Minh
- ✅ Tìm kiếm theo câu hỏi, câu trả lời, từ khóa
- ✅ Lọc theo danh mục
- ✅ Hiển thị kết quả real-time

### Quản Lý Từ Khóa
- ✅ Thêm/xóa từ khóa động
- ✅ Validate từ khóa
- ✅ Hiển thị từ khóa phổ biến

### Backup & Restore
- ✅ Tự động tạo backup
- ✅ Khôi phục từ backup
- ✅ Export/Import dữ liệu

### Validation
- ✅ Kiểm tra độ dài câu hỏi (tối thiểu 5 ký tự)
- ✅ Kiểm tra độ dài câu trả lời (tối thiểu 10 ký tự)
- ✅ Validate danh mục
- ✅ Giới hạn số từ khóa (tối đa 10)

## 🛠️ Tích Hợp Với Server

### API Endpoints (Cần implement)
```javascript
// Lưu dữ liệu
POST /api/save-qa-data
{
  "kthc_qa_database": [...],
  "metadata": {...}
}

// Tạo backup
POST /api/create-backup
{
  "kthc_qa_database": [...],
  "backup_info": {...}
}
```

### Sử Dụng QAManager Class
```javascript
// Khởi tạo
const qaManager = new QAManager();

// Tải dữ liệu
await qaManager.loadData();

// Thêm câu hỏi
qaManager.addQuestion(question, answer, category, keywords);

// Tìm kiếm
const results = qaManager.searchQuestions(query, category);

// Lấy thống kê
const stats = qaManager.getStats();

// Lưu dữ liệu
await qaManager.saveData();
```

## 📱 Responsive Design

- ✅ **Desktop**: Layout 2 cột với sidebar
- ✅ **Tablet**: Layout thích ứng
- ✅ **Mobile**: Layout 1 cột, sidebar ở trên

## 🎯 Lợi Ích

### Cho Người Dùng
- ✅ Giao diện trực quan, dễ sử dụng
- ✅ Tìm kiếm nhanh chóng
- ✅ Quản lý dữ liệu hiệu quả
- ✅ Backup dữ liệu an toàn

### Cho Developer
- ✅ Code modular, dễ maintain
- ✅ API design chuẩn
- ✅ Validation đầy đủ
- ✅ Error handling tốt

## 🔮 Tính Năng Tương Lai

- [ ] **Tìm kiếm nâng cao**: Fuzzy search, semantic search
- [ ] **Phân tích dữ liệu**: Biểu đồ, thống kê chi tiết
- [ ] **Import từ Excel**: Hỗ trợ file .xlsx
- [ ] **Export PDF**: Tạo báo cáo PDF
- [ ] **API RESTful**: Đầy đủ CRUD endpoints
- [ ] **Authentication**: Đăng nhập, phân quyền
- [ ] **Version Control**: Lịch sử thay đổi
- [ ] **Bulk Operations**: Thao tác hàng loạt

## 🐛 Troubleshooting

### Lỗi Thường Gặp

#### 1. Không tải được dữ liệu
```
Lỗi: Lỗi khi tải dữ liệu!
```
**Giải pháp**: Kiểm tra file `kthc-qa-database.json` có tồn tại không

#### 2. Không lưu được dữ liệu
```
Lỗi: HTTP error! status: 404
```
**Giải pháp**: Cần implement API endpoints trên server

#### 3. Import lỗi
```
Lỗi: Dữ liệu không đúng định dạng
```
**Giải pháp**: Kiểm tra format JSON file import

### Debug Mode
```javascript
// Bật debug mode
localStorage.setItem('debug', 'true');

// Xem logs trong Console
console.log('QA Data:', qaData);
```

## 📞 Hỗ Trợ

- **Email**: support@example.com
- **Documentation**: [Wiki](https://github.com/example/qa-manager/wiki)
- **Issues**: [GitHub Issues](https://github.com/example/qa-manager/issues)

---

**Phiên bản**: 1.0.0  
**Cập nhật**: 26/12/2024  
**Tác giả**: ChatBot GPT Assistant

