const fetch = require('node-fetch');

async function testStatisticsEndpoints() {
    const baseUrl = 'http://localhost:3001';
    
    console.log('🧪 Testing Statistics Endpoints...\n');
    
    try {
        // Test overview endpoint
        console.log('1. Testing /api/statistics/overview');
        const overviewResponse = await fetch(`${baseUrl}/api/statistics/overview`);
        const overviewData = await overviewResponse.json();
        console.log('Overview Response:', JSON.stringify(overviewData, null, 2));
        console.log('');
        
        // Test daily endpoint
        console.log('2. Testing /api/statistics/daily');
        const dailyResponse = await fetch(`${baseUrl}/api/statistics/daily`);
        const dailyData = await dailyResponse.json();
        console.log('Daily Response:', JSON.stringify(dailyData, null, 2));
        console.log('');
        
        // Test daily with parameter
        console.log('3. Testing /api/statistics/daily/7');
        const dailyParamResponse = await fetch(`${baseUrl}/api/statistics/daily/7`);
        const dailyParamData = await dailyParamResponse.json();
        console.log('Daily with Parameter Response:', JSON.stringify(dailyParamData, null, 2));
        console.log('');
        
    } catch (error) {
        console.error('❌ Error testing endpoints:', error);
    }
}

testStatisticsEndpoints();
