const { layOpenAIClient, layChatbotConfig, kiemtraOpenAIDacauhinh } = require('../config/openai');
const { ChatSessionService, ChatMessageService } = require('../services/databaseService');

// Process chat with OpenAI
async function xulyBotGPT(sessionId, message) {
  try {
    console.log('🤖 === XỬ LÝ CHAT GPT ===');
    console.log('📝 Message:', message);
    
    // Check if OpenAI is configured
    if (!kiemtraOpenAIDacauhinh()) {
      console.log('⚠️ OpenAI chưa được cấu hình, sử dụng fallback mode');
      return {
        success: false,
        error: `⚠️ **OpenAI chưa được cấu hình**
        
**Hướng dẫn cấu hình:**
1. Tạo file \`.env\` trong thư mục gốc
2. Thêm API key: \`OPENAI_API_KEY=your-api-key-here\`
3. Thêm Assistant ID: \`ASSISTANT_ID=your-assistant-id\`
4. Khởi động lại server

**Lưu ý:** API calls vẫn hoạt động bình thường.`
      };
    }
    
    const openai = layOpenAIClient();
    const config = layChatbotConfig();
    
    console.log('🔑 API Key: Đã cấu hình');
    console.log('🤖 Assistant ID:', config.assistantId);
    
    // Get or create session
    let session = await ChatSessionService.getBySessionId(sessionId);
    console.log('🔍 Session hiện tại:', session ? 'Tìm thấy' : 'Không tìm thấy');
    
    if (!session) {
      // Tạo session mới nếu chưa có
      console.log('🆕 Tạo session mới...');
      try {
        session = await ChatSessionService.create({
          session_id: sessionId,
          user_info: { user_id: 'anonymous', domain: 'unknown' },
          last_activity: new Date(),
          is_active: true
        });
        
        if (!session) {
          throw new Error('ChatSessionService.create trả về null');
        }
      } catch (error) {
        console.error('❌ Lỗi khi tạo session:', error);
        throw new Error(`Không thể tạo session mới: ${error.message}`);
      }
      
      console.log('✅ Session mới đã được tạo:', session.id);
    }
    
    console.log('📋 Session data:', {
      id: session.id,
      session_id: session.session_id,
      thread_id: session.thread_id,
      user_id: session.user_id
    });
    
    // Create or get thread
    let threadId = session.thread_id || null;
    if (!threadId) {
      console.log('🧵 Tạo thread mới...');
      const thread = await openai.beta.threads.create();
      threadId = thread.id;
      
      // Cập nhật session với thread_id mới
      await ChatSessionService.update(session.id, {
        thread_id: threadId,
        last_activity: new Date()
      });
      
      console.log(' Thread mới:', threadId);
    } else {
      console.log('🧵 Sử dụng thread hiện tại:', threadId);
    }
    
    // Add message to thread
    console.log('📝 Thêm message vào thread...');
    await openai.beta.threads.messages.create(threadId, {
      role: 'user',
      content: message
    });
    
    // Run assistant
    console.log('🚀 Chạy assistant...');
    const run = await openai.beta.threads.runs.create(threadId, {
      assistant_id: config.assistantId
    });
    
    console.log('🏃‍♂️ Run ID:', run.id);
    
    // Wait for completion
    let runStatus = run.status;
    while (runStatus === 'queued' || runStatus === 'in_progress') {
      console.log('⏳ Đang chờ... Status:', runStatus);
      await new Promise(resolve => setTimeout(resolve, 1000));
      
      const runResult = await openai.beta.threads.runs.retrieve(threadId, run.id);
      runStatus = runResult.status;
      
      if (runStatus === 'failed') {
        throw new Error('Assistant run failed');
      }
    }
    
    console.log('✅ Run completed. Status:', runStatus);
    
    // Get messages
    console.log('📥 Lấy messages...');
    const messages = await openai.beta.threads.messages.list(threadId);
    
    // Get the latest assistant message
    const assistantMessages = messages.data.filter(msg => msg.role === 'assistant');
    if (assistantMessages.length === 0) {
      throw new Error('No assistant response found');
    }
    
    const latestMessage = assistantMessages[0];
    const response = latestMessage.content[0].text.value;
    
    console.log('📤 Assistant response:', response);
    
    // Lưu message của user vào database
    await ChatMessageService.create({
      session_id: sessionId,
      message_type: 'user',
      content: message,
      created_at: new Date()
    });
    
    // Lưu response của assistant vào database
    await ChatMessageService.create({
      session_id: sessionId,
      message_type: 'bot',
      content: response,
      created_at: new Date()
    });
    
    // Cập nhật thời gian hoạt động của session
    await ChatSessionService.updateLastActivity(sessionId);
    
    return {
      success: true,
      message: response
    };
    
  } catch (error) {
    console.error('❌ Error in processChatGPT:', error);
    
    return {
      success: false,
      error: `❌ **Lỗi Chat GPT: ${error.message}**
      
**Chi tiết lỗi:**
- Session ID: ${sessionId}
- Message: ${message}
- Time: ${new Date().toLocaleString('vi-VN')}

**Gợi ý khắc phục:**
- Kiểm tra kết nối internet
- Kiểm tra API key OpenAI
- Thử lại sau vài giây`
    };
  }
}

// Get chat history
async function layLichsuchat(sessionId) {
  try {
    const messages = await ChatMessageService.getBySessionId(sessionId);
    
    return {
      success: true,
      messages: messages.map(msg => ({
        role: msg.message_type === 'user' ? 'user' : 'assistant',
        content: msg.content,
        created_at: msg.created_at
      }))
    };
    
  } catch (error) {
    console.error('❌ Error getting chat history:', error);
    return {
      success: false,
      error: error.message
    };
  }
}

module.exports = {
  xulyBotGPT,
  layLichsuchat
};
