// Format success response
function dinhDangPhanHoiThanhCong(data, message = 'Thành công') {
  return {
    success: true,
    message,
    data,
    timestamp: new Date().toISOString()
  };
}

// Format error response
function dinhDangPhanHoiLoi(error, context = '') {
  return {
    success: false,
    error: context ? `${context}: ${error.message || error}` : (error.message || error),
    timestamp: new Date().toISOString()
  };
}

// Format CTGS selection response
function dinhDangPhanHoiChonCTGS(ctgsList, totalCount, accountingDetails, userInfo) {
  const safeCtgsList = ctgsList || [];
  return dinhDangPhanHoiThanhCong({
    type: 'ctgs_selection',
    ctgsList: safeCtgsList,
    totalCount: totalCount || 0,
    accountingDetails: accountingDetails || null,
    userInfo: userInfo || {}
  }, `Tìm thấy ${safeCtgsList.length} CTGS! Vui lòng chọn một CTGS để tạo lương.`);
}

// Format salary creation response
function dinhDangPhanHoiLuong(data) {
      return dinhDangPhanHoiThanhCong({
      type: 'salary',
    ...data
  }, `Tạo lương tháng ${data.month}/${data.year} thành công!`);
}

// Format insurance creation response
function dinhDangPhanHoiBaoHiem(data) {
  const { ctgsId, apiResult, month, year, processingTime, rawData } = data;
  
  return dinhDangPhanHoiThanhCong({
    type: 'insurance',
    ctgsId,
    apiResult,
    month,
    year,
    processingTime,
    rawData,
    // Thêm thông tin chi tiết như lương
    totalEmployees: rawData?.totalEmployees || 'Đang cập nhật',
    socialInsurance: rawData?.socialInsurance || 'Đang tính toán',
    healthInsurance: rawData?.healthInsurance || 'Đang tính toán',
    unemploymentInsurance: rawData?.unemploymentInsurance || 'Đang tính toán',
    fileName: `insurance_Thang_${month}_${year}.xlsx`
  }, `Tạo bảo hiểm tháng ${month}/${year} thành công!`);
}

// Format union creation response
function dinhDangPhanHoiCongDoan(data) {
      return dinhDangPhanHoiThanhCong({
      type: 'union',
    ...data
  }, `Tạo kinh phí công đoàn tháng ${data.month}/${data.year} thành công!`);
}

// Format API error response with HTML
function dinhDangPhanHoiLoiApi(error, userInfo) {
  const errorMessage = `
<div style="color: #dc3545; font-weight: bold; margin-bottom: 10px;">Lỗi khi tạo lương: ${error.message || error}</div>

<div style="font-size: 14px; margin-bottom: 5px;"><strong>Thông tin lỗi:</strong></div>
<div style="font-size: 12px; color: #666;">
- User: ${userInfo.user}<br>
- Mã cơ quan: ${userInfo.kthcMaCoQuan}<br>
- Thời gian: ${new Date().toLocaleString('vi-VN')}
</div>`;

  return dinhDangPhanHoiLoi(errorMessage);
}

// Format no CTGS found response
function dinhDangPhanHoiKhongCoCTGS(userInfo) {
  const errorMessage = `❌ Bạn chưa tạo CTGS

**Thông tin tìm kiếm:**
- 🏢 Mã cơ quan: ${userInfo.kthcMaCoQuan}
- 👨‍💼 Mã cán bộ: ${userInfo.kthcMaCanBo}
- 📅 Năm: ${userInfo.kthcNam}
- 📋 Phân loại: ${userInfo.kthcplgd}

💡 **Gợi ý khắc phục:**
- Vui lòng tạo CTGS mới trước khi tạo lương
- Kiểm tra lại thông tin đăng nhập
- Liên hệ admin để kiểm tra quyền truy cập

⚠️ **Lưu ý:** Cần có CTGS hợp lệ để tạo lương tháng.`;

  return dinhDangPhanHoiLoi(errorMessage);
}

// Format HTML table for CTGS list
function dinhDangBangCTGSHTML(ctgsList) {
  return `
<div class="chatbot-ctgs-table">
  <table>
    <thead>
      <tr>
        <th>STT</th>
        <th>Số hiệu</th>
        <th>Kế toán</th>
        <th>Mã</th>
        <th>Số tiền (VNĐ)</th>
        <th>Tháng</th>
        <th>Thao tác</th>
      </tr>
    </thead>
    <tbody>
      ${ctgsList.map(ctgs => `
        <tr>
          <td>${ctgs.index}</td>
          <td>${ctgs.soHieu}</td>
          <td>${ctgs.keToan}</td>
          <td>${ctgs.smtm ? ctgs.smtm.slice(-4) : 'N/A'}</td>
          <td>${ctgs.dst ? ctgs.dst.toLocaleString('vi-VN') : 'N/A'}</td>
          <td>${ctgs.smn || 'N/A'}</td>
          <td>
            <button class="chatbot-ctgs-select-btn" onclick="window.ChatBotAPI.selectCTGS(${ctgs.index})">
              Chọn
            </button>
          </td>
        </tr>
      `).join('')}
    </tbody>
  </table>
</div>`;
}

// Format accounting details table
function dinhDangBangHachToanHTML(accountingDetails) {
  if (!accountingDetails || !accountingDetails.data) {
    return '';
  }

  return `
<div style="font-size: 16px; font-weight: bold; margin-bottom: 10px;">Chi tiết hạch toán</div>
<div class="chatbot-accounting-table">
  <table>
    <thead>
      <tr>
        <th>T.Mục</th>
        <th>Nội dung</th>
        <th>Số tiền (VNĐ)</th>
        <th>Nguồn</th>
      </tr>
    </thead>
    <tbody>
      ${accountingDetails.data.map((item, index) => `
        <tr>
          <td>${item.Smtm ? item.Smtm.slice(-4) : 'N/A'}</td>
          <td>${item.Ndctcts || 'N/A'}</td>
          <td>${item.Dst ? item.Dst.toLocaleString('vi-VN') : 'N/A'}</td>
          <td>${item.Smn || 'N/A'}</td>
        </tr>
      `).join('')}
      <tr style="background: #e8f5e8; font-weight: bold;">
        <td colspan="2" style="text-align: right;"><strong>Tổng cộng:</strong></td>
        <td style="color: #28a745; white-space: nowrap;"><strong>${accountingDetails.summary && accountingDetails.summary[0] ? accountingDetails.summary[0].toLocaleString('vi-VN') : 'N/A'}</strong></td>
        <td></td>
      </tr>
    </tbody>
  </table>
</div>`;
}

// Format CTGS create form response
function dinhDangPhanHoiFormCTGS(formData, options, userInfo = {}) {
  // Debug: Log thông tin userInfo
  console.log('🔍 Debug dinhdanhCTGSFormResponse - userInfo:', {
    kthcNlb: userInfo.kthcNlb,
    kthcPtkt: userInfo.kthcPtkt,
    hasKthcNlb: !!userInfo.kthcNlb,
    hasKthcPtkt: !!userInfo.kthcPtkt,
    userInfoKeys: Object.keys(userInfo)
  });
  
  return {
    success: true,
    data: {
      type: 'ctgs_create_form',
      message: 'Chưa có CTGS, vui lòng tạo CTGS mới trước khi tạo lương',
      formData: formData,
      options: options,
      userInfo: userInfo,
      html: taoCTGSFormHTML(formData, options, userInfo)
    }
  };
}

// Generate CTGS form HTML
function taoFormCTGSHTML(formData, options, userInfo = {}) {
  // Debug: Log thông tin userInfo
  console.log('🔍 Debug taoCTGSFormHTML - userInfo:', {
    kthcNlb: userInfo.kthcNlb,
    kthcPtkt: userInfo.kthcPtkt,
    hasKthcNlb: !!userInfo.kthcNlb,
    hasKthcPtkt: !!userInfo.kthcPtkt
  });
  
  // Lấy giá trị từ userInfo hoặc formData
  const kthcNlb = userInfo.kthcNlb || formData.Nlctgs || '';
  const kthcPtkt = userInfo.kthcPtkt || formData.Ktctgs || '';
  
  console.log('🔍 Debug taoCTGSFormHTML - Giá trị cuối cùng:', {
    kthcNlb: kthcNlb,
    kthcPtkt: kthcPtkt
  });
  
  return `
<div style="padding: 15px; border: 1px solid #ddd; border-radius: 5px; background: #f9f9f9;">
  <h3 style="margin: 0 0 10px 0; color: #333;">📋 Tạo CTGS mới</h3>
  <p style="margin: 0 0 15px 0; color: #666; font-size: 14px;">Chưa có CTGS, vui lòng tạo CTGS trước</p>
  
  <form id="ctgsForm" onsubmit="return false;">
    <div style="margin-bottom: 10px;">
      <label style="display: block; margin-bottom: 3px; font-weight: 500; color: #333;">Số hiệu: <span style="color: red;">*</span></label>
      <input type="text" name="Shctgs" value="${formData.Shctgs || ''}" placeholder="Nhập số hiệu" required 
             style="width: 100%; padding: 6px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box;">
    </div>

    <div style="margin-bottom: 10px;">
      <label style="display: block; margin-bottom: 3px; font-weight: 500; color: #333;">Ngày ghi sổ:</label>
      <input type="date" name="Ntctgs" value="${formData.Ntctgs || ''}" 
             style="width: 100%; padding: 6px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box;">
    </div>

    <div style="margin-bottom: 10px;">
      <label style="display: block; margin-bottom: 3px; font-weight: 500; color: #333;">Phân loại:</label>
      <select name="Plctgs" style="width: 100%; padding: 6px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box;">
        ${options.plctgs.map(option => 
          `<option value="${option}" ${formData.Plctgs === option ? 'selected' : ''}>${option}</option>`
        ).join('')}
      </select>
    </div>

    <div style="margin-bottom: 10px;">
      <label style="display: block; margin-bottom: 3px; font-weight: 500; color: #333;">Số CT:</label>
      <input type="number" name="Sgctgs" value="${formData.Sgctgs || 0}" placeholder="0" 
             style="width: 100%; padding: 6px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box;">
    </div>

    <div style="margin-bottom: 10px;">
      <label style="display: block; margin-bottom: 3px; font-weight: 500; color: #333;">Lập biểu:</label>
      <input type="text" name="Nlctgs" value="${kthcNlb}" placeholder="Nhập tên người lập biểu" 
             style="width: 100%; padding: 6px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box;">
    </div>

    <div style="margin-bottom: 10px;">
      <label style="display: block; margin-bottom: 3px; font-weight: 500; color: #333;">Kế toán:</label>
      <input type="text" name="Ktctgs" value="${kthcPtkt}" placeholder="Nhập tên kế toán" 
             style="width: 100%; padding: 6px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box;">
    </div>

    <div style="margin-bottom: 15px;">
      <label style="display: block; margin-bottom: 3px; font-weight: 500; color: #333;">CT ghi sổ:</label>
      <select name="Dcctgs" style="width: 100%; padding: 6px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box;">
        ${options.dcctgs.map(option => 
          `<option value="${option}" ${formData.Dcctgs === option ? 'selected' : ''}>${option}</option>`
        ).join('')}
      </select>
    </div>

    <div style="display: flex; gap: 10px;">
      <button type="button" id="submitCTGSBtn" onclick="createCTGS()" style="flex: 1; padding: 8px; background: #28a745; color: white; border: none; border-radius: 3px; cursor: pointer; font-weight: 500;">
        ✅ Tạo CTGS
      </button>
      <button type="button" id="cancelCTGSBtn" onclick="cancelCTGS()" style="flex: 1; padding: 8px; background: #dc3545; color: white; border: none; border-radius: 3px; cursor: pointer;">
        ❌ Hủy
      </button>
    </div>
  </form>
</div>


  `;
}

module.exports = {
  dinhDangPhanHoiThanhCong,
  dinhDangPhanHoiLoi,
  dinhDangPhanHoiChonCTGS,
  dinhDangPhanHoiLuong,
  dinhDangPhanHoiBaoHiem,
  dinhDangPhanHoiCongDoan,
  dinhDangPhanHoiLoiApi,
  dinhDangPhanHoiKhongCoCTGS,
  dinhDangBangCTGSHTML,
  dinhDangBangHachToanHTML,
  dinhDangPhanHoiFormCTGS,
  taoFormCTGSHTML
};
